/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.reliable;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.message.KeepAlive;
import org.codehaus.activemq.message.Receipt;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportStatusEvent;
import org.codehaus.activemq.transport.TransportStatusEventListener;
import org.codehaus.activemq.util.IdGenerator;

public class KeepAliveDaemon
implements TransportStatusEventListener {
    private static final Log log = LogFactory.getLog((Class)KeepAliveDaemon.class);
    private long keepAliveInterval = 15000L;
    private long keepAliveTimeout = 10000L;
    private IdGenerator packetIdGenerator;
    private Timer timer = null;
    private KeepAliveTask task = null;
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private SynchronizedBoolean stopped = new SynchronizedBoolean(false);
    private TransportChannel channel;

    public KeepAliveDaemon(TransportChannel channel) {
        this.channel = channel;
        this.timer = new Timer();
        this.packetIdGenerator = new IdGenerator();
        channel.addTransportStatusEventListener(this);
    }

    public void setKeepAliveInterval(long interval) {
        this.keepAliveInterval = interval;
        if (this.started.and(!this.stopped.get())) {
            this.restart();
        }
    }

    public void setKeepAliveTimeout(long timeoutInterval) {
        this.keepAliveTimeout = (int)timeoutInterval;
    }

    public void start() {
        if (this.started.commit(false, true)) {
            log.debug((Object)("Scheduling keep-alive every " + this.keepAliveInterval + " millisecond."));
            this.task = new KeepAliveTask();
            this.timer.scheduleAtFixedRate((TimerTask)this.task, 0L, this.keepAliveInterval);
        }
    }

    public void stop() {
        if (this.stopped.commit(false, true)) {
            log.debug((Object)"Stopping keep-alive.");
            this.started.commit(true, false);
            if (this.task != null) {
                this.task.cancel();
            }
        }
    }

    public void restart() {
        log.debug((Object)"Restarting keep-alive.");
        this.stop();
        this.start();
    }

    public void statusChanged(TransportStatusEvent event) {
        switch (event.getChannelStatus()) {
            case 1: 
            case 3: {
                this.start();
                break;
            }
            case 2: 
            case 5: {
                this.stop();
            }
        }
    }

    protected class KeepAliveTask
    extends TimerTask {
        protected KeepAliveTask() {
        }

        public void run() {
            try {
                if (KeepAliveDaemon.this.channel.isTransportConnected()) {
                    log.debug((Object)("Sending keep-alive on channel " + KeepAliveDaemon.this.channel.toString()));
                    KeepAlive packet = new KeepAlive();
                    packet.setId(KeepAliveDaemon.this.packetIdGenerator.generateId());
                    Receipt rcpt = KeepAliveDaemon.this.channel.send(packet, (int)KeepAliveDaemon.this.keepAliveTimeout);
                    if (rcpt == null) {
                        log.warn((Object)("Peer for channel " + KeepAliveDaemon.this.channel.toString() + " has not responded in " + KeepAliveDaemon.this.keepAliveTimeout + " milliseconds. Forcing disconnect."));
                        KeepAliveDaemon.this.channel.forceDisconnect();
                    }
                } else if (KeepAliveDaemon.this.channel.isPendingStop()) {
                    this.cancel();
                    return;
                }
            }
            catch (JMSException e) {
                log.error((Object)("Error sending keep-alive to channel " + KeepAliveDaemon.this.channel.toString() + ". Treating as temporary problem."), (Throwable)e);
            }
        }
    }
}

