/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.peer;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerConnector;
import org.codehaus.activemq.broker.impl.BrokerConnectorImpl;
import org.codehaus.activemq.broker.impl.BrokerContainerImpl;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.DiscoveryNetworkConnector;
import org.codehaus.activemq.transport.NetworkConnector;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.multicast.MulticastDiscoveryAgent;
import org.codehaus.activemq.transport.vm.VmTransportChannel;
import org.codehaus.activemq.util.IdGenerator;

public class PeerTransportChannel
extends VmTransportChannel {
    private static final Log log = LogFactory.getLog((Class)PeerTransportChannel.class);
    protected WireFormat wireFormat;
    protected List uris;
    protected TransportChannel channel;
    protected String brokerDiscoveryURI;
    private String remoteUserName;
    private String remotePassword;
    private String brokerName;
    private boolean doDiscovery;
    private BrokerConnector brokerConnector;

    PeerTransportChannel(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
        this.uris = Collections.synchronizedList(new ArrayList());
        this.brokerDiscoveryURI = "multicast://224.1.2.3:6066";
        IdGenerator idGen = new IdGenerator();
        this.brokerName = idGen.generateId();
        this.doDiscovery = true;
    }

    public PeerTransportChannel(WireFormat wireFormat, List uris) throws JMSException {
        this(wireFormat);
        if (uris == null || uris.isEmpty()) {
            throw new JMSException("there shouldbe at least one uri (embedded broker bind address) specified");
        }
        this.uris.addAll(uris);
    }

    public boolean isTransportConnected() {
        return true;
    }

    public boolean requiresEmbeddedBroker() {
        return true;
    }

    public BrokerConnector getEmbeddedBrokerConnector() throws JMSException {
        try {
            if (this.brokerConnector == null) {
                String brokerConnectorURI = this.uris.get(0).toString();
                BrokerContainerImpl container = new BrokerContainerImpl(this.brokerName);
                container.addConnector(brokerConnectorURI);
                NetworkConnector networkConnector = null;
                if (this.doDiscovery) {
                    networkConnector = new DiscoveryNetworkConnector(container);
                    MulticastDiscoveryAgent agent = new MulticastDiscoveryAgent(new URI(this.brokerDiscoveryURI));
                    container.setDiscoveryAgent(agent);
                } else {
                    networkConnector = new NetworkConnector(container);
                }
                for (int i = 1; i < this.uris.size(); ++i) {
                    networkConnector.addNetworkChannel(this.uris.get(i).toString());
                }
                container.addNetworkConnector(networkConnector);
                this.brokerConnector = new BrokerConnectorImpl(container, brokerConnectorURI, this.wireFormat);
                container.start();
            }
            return this.brokerConnector;
        }
        catch (Exception e) {
            String errorStr = "Failed to get embedded connector";
            log.error((Object)errorStr, (Throwable)e);
            JMSException jmsEx = new JMSException(errorStr);
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
    }

    public String getBrokerDiscoveryURI() {
        return this.brokerDiscoveryURI;
    }

    public void setBrokerDiscoveryURI(String brokerDiscoveryURI) {
        this.brokerDiscoveryURI = brokerDiscoveryURI;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public boolean isDoDiscovery() {
        return this.doDiscovery;
    }

    public void setDoDiscovery(boolean doDiscovery) {
        this.doDiscovery = doDiscovery;
    }

    public List getUris() {
        return this.uris;
    }

    public void setUris(List uris) {
        this.uris = uris;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }
}

