/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.composite;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.TimeoutExpiredException;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketListener;
import org.codehaus.activemq.message.Receipt;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelProvider;
import org.codehaus.activemq.transport.TransportChannelSupport;
import org.codehaus.activemq.transport.TransportStatusEvent;
import org.codehaus.activemq.transport.TransportStatusEventListener;

public class CompositeTransportChannel
extends TransportChannelSupport
implements TransportStatusEventListener {
    private static final Log log = LogFactory.getLog((Class)CompositeTransportChannel.class);
    protected WireFormat wireFormat;
    protected List uris;
    protected TransportChannel channel;
    protected SynchronizedBoolean closed;
    protected SynchronizedBoolean started;
    protected int maximumRetries = 10;
    protected long failureSleepTime = 500L;
    protected URI currentURI;
    private long establishConnectionTimeout = 30000L;

    public CompositeTransportChannel(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
        this.uris = Collections.synchronizedList(new ArrayList());
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
    }

    public CompositeTransportChannel(WireFormat wireFormat, List uris) {
        this(wireFormat);
        this.uris.addAll(uris);
    }

    public String toString() {
        return "CompositeTransportChannel: " + this.channel;
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.establishConnection(this.establishConnectionTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.closed.commit(false, true) && this.channel != null) {
            try {
                this.channel.stop();
            }
            catch (Exception e) {
                log.warn((Object)("Caught while closing: " + e + ". Now Closed"), (Throwable)e);
            }
            finally {
                this.channel = null;
                super.stop();
            }
        }
    }

    public void forceDisconnect() {
        if (this.channel != null) {
            this.channel.forceDisconnect();
        }
    }

    public Receipt send(Packet packet) throws JMSException {
        return this.getChannel().send(packet);
    }

    public Receipt send(Packet packet, int timeout) throws JMSException {
        return this.getChannel().send(packet, timeout);
    }

    public void asyncSend(Packet packet) throws JMSException {
        this.getChannel().asyncSend(packet);
    }

    public void setPacketListener(PacketListener listener) {
        super.setPacketListener(listener);
        if (this.channel != null) {
            this.channel.setPacketListener(listener);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        super.setExceptionListener(listener);
        if (this.channel != null) {
            this.channel.setExceptionListener(listener);
        }
    }

    public boolean isMulticast() {
        return false;
    }

    public long getEstablishConnectionTimeout() {
        return this.establishConnectionTimeout;
    }

    public void setEstablishConnectionTimeout(long establishConnectionTimeout) {
        this.establishConnectionTimeout = establishConnectionTimeout;
    }

    public int getMaximumRetries() {
        return this.maximumRetries;
    }

    public void setMaximumRetries(int maximumRetries) {
        this.maximumRetries = maximumRetries;
    }

    public long getFailureSleepTime() {
        return this.failureSleepTime;
    }

    public void setFailureSleepTime(long failureSleepTime) {
        this.failureSleepTime = failureSleepTime;
    }

    public List getUris() {
        return this.uris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUris(List list) {
        List list2 = this.uris;
        synchronized (list2) {
            this.uris.clear();
            this.uris.addAll(list);
        }
    }

    public boolean canProcessWireFormatVersion(int version) {
        return this.channel != null ? this.channel.canProcessWireFormatVersion(version) : true;
    }

    public int getCurrentWireFormatVersion() {
        return this.channel != null ? this.channel.getCurrentWireFormatVersion() : 1;
    }

    protected void establishConnection(long timeout) throws JMSException {
        boolean connected = false;
        long time = this.failureSleepTime;
        long startTime = System.currentTimeMillis();
        for (int i = 0; !(connected || i >= this.maximumRetries && this.maximumRetries > 0 || this.closed.get() || this.isPendingStop()); ++i) {
            ArrayList list = new ArrayList(this.getUris());
            if (i > 0) {
                if (this.maximumRetries > 0 || timeout > 0L) {
                    long current = System.currentTimeMillis();
                    if (timeout >= 0L && current + time > startTime + timeout) {
                        time = startTime + timeout - current;
                    }
                    if (current > startTime + timeout || time <= 0L) {
                        throw new TimeoutExpiredException("Could not connect to any of the URIs: " + list);
                    }
                }
                log.info((Object)("Could not connect; sleeping for: " + time + " millis and trying again"));
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException e) {
                    log.warn((Object)("Sleep interupted: " + e), (Throwable)e);
                }
                if (this.maximumRetries > 0) {
                    time *= 2L;
                }
            }
            while (!(connected || list.isEmpty() || this.closed.get() || this.isPendingStop())) {
                URI uri = this.extractURI(list);
                try {
                    this.attemptToConnect(uri);
                    this.configureChannel();
                    connected = true;
                    this.currentURI = uri;
                }
                catch (JMSException e) {
                    log.info((Object)("Could not connect to: " + uri + ". Reason: " + (Object)((Object)e)));
                }
            }
        }
        if (!connected && !this.closed.get()) {
            StringBuffer buffer = new StringBuffer("");
            Object[] uriArray = this.getUris().toArray();
            for (int i = 0; i < uriArray.length; ++i) {
                buffer.append(uriArray[i]);
                if (i >= uriArray.length - 1) continue;
                buffer.append(",");
            }
            JMSException jmsEx = new JMSException("Failed to connect to resource(s): " + buffer.toString());
            throw jmsEx;
        }
    }

    protected TransportChannel getChannel() throws JMSException {
        if (this.channel == null) {
            throw new JMSException("No TransportChannel connection available");
        }
        return this.channel;
    }

    protected void configureChannel() {
        PacketListener packetListener;
        ExceptionListener exceptionListener = this.getExceptionListener();
        if (exceptionListener != null) {
            this.channel.setExceptionListener(exceptionListener);
        }
        if ((packetListener = this.getPacketListener()) != null) {
            this.channel.setPacketListener(packetListener);
        }
        this.channel.addTransportStatusEventListener(this);
    }

    protected URI extractURI(List list) throws JMSException {
        int idx = 0;
        if (list.size() > 1) {
            while ((idx = (int)(Math.random() * (double)list.size())) < 0 || idx >= list.size()) {
            }
        }
        return (URI)list.remove(idx);
    }

    protected void attemptToConnect(URI uri) throws JMSException {
        this.channel = TransportChannelProvider.create(this.wireFormat, uri);
        if (this.started.get()) {
            this.channel.start();
        }
    }

    public void statusChanged(TransportStatusEvent event) {
        this.fireStatusEvent(event);
    }

    public boolean isTransportConnected() {
        return this.channel == null ? false : this.channel.isTransportConnected();
    }
}

