/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.Broker;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.service.Transaction;
import org.codehaus.activemq.service.TransactionManager;
import org.codehaus.activemq.service.impl.LocalTransactionCommand;
import org.codehaus.activemq.service.impl.XATransactionCommand;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class TransactionManagerImpl
implements TransactionManager {
    private static final Log log = LogFactory.getLog((Class)TransactionManagerImpl.class);
    private Broker broker;
    private PreparedTransactionStore preparedTransactions;
    private Map activeClients = new ConcurrentHashMap();
    private Map localTxs = new ConcurrentHashMap();
    private Map xaTxs = new ConcurrentHashMap();
    private final ThreadLocal contextTx = new ThreadLocal();

    public TransactionManagerImpl(Broker broker, PreparedTransactionStore preparedTransactions) {
        this.preparedTransactions = preparedTransactions;
        this.broker = broker;
    }

    public Transaction createLocalTransaction(BrokerClient client, String txid) throws JMSException {
        LocalTransactionCommand t = new LocalTransactionCommand(this.broker, this.localTxs, txid);
        this.localTxs.put(txid, t);
        return t;
    }

    public Transaction createXATransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        XATransactionCommand t = new XATransactionCommand(this.broker, xid, this.xaTxs, this.preparedTransactions);
        this.xaTxs.put(xid, t);
        return t;
    }

    public Transaction getLocalTransaction(String txid) throws JMSException {
        Transaction tx = (Transaction)this.localTxs.get(txid);
        if (tx == null) {
            throw new JMSException("Transaction '" + txid + "' has not been started.");
        }
        return tx;
    }

    public Transaction getXATransaction(ActiveMQXid xid) throws XAException {
        Transaction tx = (Transaction)this.xaTxs.get(xid);
        if (tx == null) {
            XAException e = new XAException("Transaction '" + xid + "' has not been started.");
            e.errorCode = -4;
            throw e;
        }
        return tx;
    }

    public ActiveMQXid[] getPreparedXATransactions() throws XAException {
        return this.preparedTransactions.getXids();
    }

    public void setContexTransaction(Transaction tx) {
        this.contextTx.set(tx);
    }

    public Transaction getContexTransaction() {
        return (Transaction)this.contextTx.get();
    }

    public void cleanUpClient(BrokerClient client) throws JMSException {
        List list = (List)this.activeClients.remove(client);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    Transaction t;
                    Object o = list.get(i);
                    if (o instanceof String) {
                        t = this.getLocalTransaction((String)o);
                        t.rollback();
                        continue;
                    }
                    t = this.getXATransaction((ActiveMQXid)o);
                    t.rollback();
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)"ERROR Rolling back disconnected client's transactions: ", (Throwable)e);
                }
            }
            list.clear();
        }
    }

    public void loadTransaction(ActiveMQXid xid, Transaction transaction) throws XAException {
        if (transaction instanceof XATransactionCommand) {
            XATransactionCommand xaTransaction = (XATransactionCommand)transaction;
            xaTransaction.initialise(this.xaTxs, this.preparedTransactions);
        }
        transaction.setBroker(this.broker);
        this.xaTxs.put(xid, transaction);
    }

    public void start() throws JMSException {
        this.preparedTransactions.start();
        try {
            this.preparedTransactions.loadPreparedTransactions(this);
        }
        catch (XAException e) {
            throw JMSExceptionHelper.newJMSException("Failed to recover: " + e, e);
        }
    }

    public void stop() throws JMSException {
        this.preparedTransactions.stop();
    }

    private void addActiveTransaction(BrokerClient client, Object transactionId) {
        ArrayList<Object> list = (ArrayList<Object>)this.activeClients.get(client);
        if (list == null) {
            list = new ArrayList<Object>();
            this.activeClients.put(client, list);
        }
        list.add(transactionId);
    }

    private void removeActiveTransaction(BrokerClient client, Object transactionId) {
        List list = (List)this.activeClients.get(client);
        if (list != null) {
            list.remove(transactionId);
        }
    }
}

