/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.service.MessageContainerAdmin;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.QueueList;
import org.codehaus.activemq.service.QueueListEntry;
import org.codehaus.activemq.service.QueueMessageContainer;
import org.codehaus.activemq.service.impl.DefaultQueueList;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.util.Callback;
import org.codehaus.activemq.util.TransactionTemplate;

public class DurableQueueMessageContainer
implements QueueMessageContainer,
MessageContainerAdmin {
    private static final Log log = LogFactory.getLog((Class)DurableQueueMessageContainer.class);
    private MessageStore messageStore;
    private String destinationName;
    private QueueList messagesToBeDelivered;
    private QueueList deliveredMessages;
    private PersistenceAdapter persistenceAdapter;
    private TransactionTemplate transactionTemplate;

    public DurableQueueMessageContainer(PersistenceAdapter persistenceAdapter, MessageStore messageStore, String destinationName) {
        this(persistenceAdapter, messageStore, destinationName, new DefaultQueueList(), new DefaultQueueList());
    }

    public DurableQueueMessageContainer(PersistenceAdapter persistenceAdapter, MessageStore messageStore, String destinationName, QueueList messagesToBeDelivered, QueueList deliveredMessages) {
        this.persistenceAdapter = persistenceAdapter;
        this.messageStore = messageStore;
        this.destinationName = destinationName;
        this.messagesToBeDelivered = messagesToBeDelivered;
        this.deliveredMessages = deliveredMessages;
        this.transactionTemplate = new TransactionTemplate(persistenceAdapter);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageIdentity addMessage(ActiveMQMessage message) throws JMSException {
        MessageIdentity answer = this.messageStore.addMessage(message);
        DurableQueueMessageContainer durableQueueMessageContainer = this;
        synchronized (durableQueueMessageContainer) {
            this.messagesToBeDelivered.add(answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(MessageIdentity messageID, MessageAck ack) throws JMSException {
        MessageIdentity storedIdentity = null;
        DurableQueueMessageContainer durableQueueMessageContainer = this;
        synchronized (durableQueueMessageContainer) {
            MessageIdentity identity;
            QueueListEntry entry = this.deliveredMessages.getFirstEntry();
            while (entry != null) {
                identity = (MessageIdentity)entry.getElement();
                if (messageID.equals(identity)) {
                    this.deliveredMessages.remove(entry);
                    storedIdentity = identity;
                    break;
                }
                entry = this.deliveredMessages.getNextEntry(entry);
            }
            if (storedIdentity == null) {
                entry = this.messagesToBeDelivered.getFirstEntry();
                while (entry != null) {
                    identity = (MessageIdentity)entry.getElement();
                    if (messageID.equals(identity)) {
                        this.messagesToBeDelivered.remove(entry);
                        storedIdentity = identity;
                        break;
                    }
                    entry = this.messagesToBeDelivered.getNextEntry(entry);
                }
            }
        }
        if (storedIdentity == null) {
            log.error((Object)("Attempt to acknowledge unknown messageID: " + messageID));
        } else {
            this.messageStore.removeMessage(storedIdentity, ack);
        }
    }

    public ActiveMQMessage getMessage(MessageIdentity messageID) throws JMSException {
        return this.messageStore.getMessage(messageID);
    }

    public boolean containsMessage(MessageIdentity messageIdentity) throws JMSException {
        return this.getMessage(messageIdentity) != null;
    }

    public void registerMessageInterest(MessageIdentity messageIdentity) {
    }

    public void unregisterMessageInterest(MessageIdentity messageIdentity, MessageAck ack) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage poll() throws JMSException {
        ActiveMQMessage message = null;
        MessageIdentity messageIdentity = null;
        DurableQueueMessageContainer durableQueueMessageContainer = this;
        synchronized (durableQueueMessageContainer) {
            messageIdentity = (MessageIdentity)this.messagesToBeDelivered.removeFirst();
            if (messageIdentity != null) {
                this.deliveredMessages.add(messageIdentity);
            }
        }
        if (messageIdentity != null) {
            message = this.messageStore.getMessage(messageIdentity);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage peekNext(MessageIdentity messageID) throws JMSException {
        ActiveMQMessage answer = null;
        MessageIdentity identity = null;
        DurableQueueMessageContainer durableQueueMessageContainer = this;
        synchronized (durableQueueMessageContainer) {
            if (messageID == null) {
                identity = (MessageIdentity)this.messagesToBeDelivered.getFirst();
            } else {
                int index = this.messagesToBeDelivered.indexOf(messageID);
                if (index >= 0 && index + 1 < this.messagesToBeDelivered.size()) {
                    identity = (MessageIdentity)this.messagesToBeDelivered.get(index + 1);
                }
            }
        }
        if (identity != null) {
            answer = this.messageStore.getMessage(identity);
        }
        return answer;
    }

    public synchronized void returnMessage(MessageIdentity messageIdentity) throws JMSException {
        boolean result = this.deliveredMessages.remove(messageIdentity);
        this.messagesToBeDelivered.addFirst(messageIdentity);
    }

    public synchronized void reset() throws JMSException {
        int count = 0;
        MessageIdentity messageIdentity = (MessageIdentity)this.deliveredMessages.removeFirst();
        while (messageIdentity != null) {
            this.messagesToBeDelivered.add(count++, messageIdentity);
            messageIdentity = (MessageIdentity)this.deliveredMessages.removeFirst();
        }
    }

    public synchronized void start() throws JMSException {
        final DurableQueueMessageContainer container = this;
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                DurableQueueMessageContainer.this.messageStore.start();
                DurableQueueMessageContainer.this.messageStore.recover(container);
            }
        });
    }

    public synchronized void recoverMessageToBeDelivered(MessageIdentity messageIdentity) throws JMSException {
        this.messagesToBeDelivered.add(messageIdentity);
    }

    public void stop() throws JMSException {
        this.messageStore.stop();
    }

    public MessageContainerAdmin getMessageContainerAdmin() {
        return this;
    }

    public void empty() throws JMSException {
    }
}

