/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.boundedvm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.filter.AndFilter;
import org.codehaus.activemq.filter.DestinationMap;
import org.codehaus.activemq.filter.Filter;
import org.codehaus.activemq.filter.FilterFactory;
import org.codehaus.activemq.filter.FilterFactoryImpl;
import org.codehaus.activemq.filter.NoLocalFilter;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.util.MemoryBoundedQueue;
import org.codehaus.activemq.message.util.MemoryBoundedQueueManager;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.MessageContainerManager;
import org.codehaus.activemq.service.boundedvm.TransientQueueBoundedMessageContainer;
import org.codehaus.activemq.service.boundedvm.TransientQueueSubscription;

public class TransientQueueBoundedMessageManager
implements MessageContainerManager,
Runnable {
    private static final int DEFAULT_GARBAGE_COLLECTION_CAPACITY_LIMIT = 10;
    private static final long DEFAULT_INACTIVE_TIMEOUT = 30000L;
    private static final Log log = LogFactory.getLog((Class)TransientQueueBoundedMessageManager.class);
    private MemoryBoundedQueueManager queueManager;
    private ConcurrentHashMap containers;
    private ConcurrentHashMap subscriptions;
    private FilterFactory filterFactory;
    private SynchronizedBoolean started;
    private SynchronizedBoolean doingGarbageCollection;
    private Map destinations;
    private DestinationMap destinationMap;
    private PooledExecutor threadPool;
    private long inactiveTimeout;
    private int garbageCoolectionCapacityLimit;

    public TransientQueueBoundedMessageManager(MemoryBoundedQueueManager mgr) {
        this.queueManager = mgr;
        this.containers = new ConcurrentHashMap();
        this.destinationMap = new DestinationMap();
        this.destinations = new ConcurrentHashMap();
        this.subscriptions = new ConcurrentHashMap();
        this.filterFactory = new FilterFactoryImpl();
        this.started = new SynchronizedBoolean(false);
        this.doingGarbageCollection = new SynchronizedBoolean(false);
        this.threadPool = new PooledExecutor();
        this.threadPool.setThreadFactory((ThreadFactory)new TransientQueueThreadFactory());
        this.inactiveTimeout = 30000L;
        this.garbageCoolectionCapacityLimit = 10;
    }

    public int getGarbageCoolectionCapacityLimit() {
        return this.garbageCoolectionCapacityLimit;
    }

    public void setGarbageCoolectionCapacityLimit(int garbageCoolectionCapacityLimit) {
        this.garbageCoolectionCapacityLimit = garbageCoolectionCapacityLimit;
    }

    public long getInactiveTimeout() {
        return this.inactiveTimeout;
    }

    public void setInactiveTimeout(long inactiveTimeout) {
        this.inactiveTimeout = inactiveTimeout;
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                container.start();
            }
            try {
                this.threadPool.execute((Runnable)this);
            }
            catch (InterruptedException e) {
                JMSException jmsEx = new JMSException("Garbage collection interupted on start()");
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false)) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                container.stop();
            }
            this.threadPool.interruptAll();
        }
    }

    public void run() {
        while (this.started.get()) {
            this.doGarbageCollection();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        ActiveMQDestination destination = info.getDestination();
        if (destination.isQueue()) {
            String name;
            TransientQueueSubscription ts;
            TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)this.containers.get((Object)destination);
            if (container == null) {
                MemoryBoundedQueue queue = this.queueManager.getMemoryBoundedQueue(client.toString());
                container = new TransientQueueBoundedMessageContainer((Executor)this.threadPool, this.queueManager, destination);
                this.addContainer(container);
                if (this.started.get()) {
                    container.start();
                }
            }
            if ((ts = container.addConsumer(this.createFilter(info), info, client)) != null) {
                this.subscriptions.put((Object)info.getConsumerId(), (Object)ts);
            }
            if (!this.destinations.containsKey(name = destination.getPhysicalName())) {
                this.destinations.put(name, destination);
            }
        }
    }

    public synchronized void removeMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        ActiveMQDestination destination = info.getDestination();
        if (destination.isQueue()) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                if (container == null) continue;
                container.removeConsumer(info);
            }
            this.subscriptions.remove((Object)info.getConsumerId());
        }
    }

    public void deleteSubscription(String clientId, String subscriberName) throws JMSException {
    }

    public void sendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        ActiveMQDestination destination = message.getJMSActiveMQDestination();
        if (destination.isQueue() && message.isTemporary()) {
            TransientQueueBoundedMessageContainer container;
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                this.doGarbageCollection();
            }
            if ((container = (TransientQueueBoundedMessageContainer)this.containers.get((Object)destination)) == null) {
                MemoryBoundedQueue queue = this.queueManager.getMemoryBoundedQueue(client.toString());
                container = new TransientQueueBoundedMessageContainer((Executor)this.threadPool, this.queueManager, destination);
                this.addContainer(container);
                if (this.started.get()) {
                    container.start();
                }
            }
            Set set = this.destinationMap.get(message.getJMSActiveMQDestination());
            Iterator i = set.iterator();
            while (i.hasNext()) {
                container = (TransientQueueBoundedMessageContainer)i.next();
                container.enqueue(message);
            }
        }
    }

    public void acknowledgeMessage(BrokerClient client, MessageAck ack) throws JMSException {
        block1: {
            ActiveMQMessage message;
            TransientQueueSubscription ts = (TransientQueueSubscription)this.subscriptions.get((Object)ack.getConsumerId());
            if (ts == null || (message = ts.acknowledgeMessage(ack.getMessageID())) == null || ack.isMessageRead()) break block1;
            message.setJMSRedelivered(true);
            Set set = this.destinationMap.get(message.getJMSActiveMQDestination());
            Iterator i = set.iterator();
            if (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                container.enqueueFirst(message);
            }
        }
    }

    public void acknowledgeTransactedMessage(BrokerClient client, String transactionId, MessageAck ack) throws JMSException {
    }

    public void redeliverMessage(BrokerClient client, MessageAck ack) throws JMSException {
        block1: {
            ActiveMQMessage message;
            TransientQueueSubscription ts = (TransientQueueSubscription)this.subscriptions.get((Object)ack.getConsumerId());
            if (ts == null || (message = ts.acknowledgeMessage(ack.getMessageID())) == null) break block1;
            message.setJMSRedelivered(true);
            Set set = this.destinationMap.get(message.getJMSActiveMQDestination());
            Iterator i = set.iterator();
            if (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                container.enqueueFirst(message);
            }
        }
    }

    public void poll() throws JMSException {
    }

    public void commitTransaction(BrokerClient client, String transactionId) throws JMSException {
    }

    public void rollbackTransaction(BrokerClient client, String transactionId) {
    }

    public MessageContainer getContainer(String physicalName) throws JMSException {
        Object key = this.destinations.get(physicalName);
        if (key != null) {
            return (MessageContainer)this.containers.get(key);
        }
        return null;
    }

    public Map getDestinations() {
        return Collections.unmodifiableMap(this.destinations);
    }

    protected Filter createFilter(ConsumerInfo info) throws JMSException {
        Filter filter = this.filterFactory.createFilter(info.getDestination(), info.getSelector());
        if (info.isNoLocal()) {
            filter = new AndFilter(filter, new NoLocalFilter(info.getClientId()));
        }
        return filter;
    }

    private void doGarbageCollection() {
        if (this.doingGarbageCollection.commit(true, false)) {
            TransientQueueBoundedMessageContainer container;
            Iterator i;
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                i = this.containers.values().iterator();
                while (i.hasNext()) {
                    container = (TransientQueueBoundedMessageContainer)i.next();
                    container.removeExpiredMessages();
                }
            }
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                i = this.containers.values().iterator();
                while (i.hasNext()) {
                    container = (TransientQueueBoundedMessageContainer)i.next();
                    if (container.isActive() || container.getIdleTimestamp() >= System.currentTimeMillis() - this.inactiveTimeout) continue;
                    this.removeContainer(container);
                    log.warn((Object)("memory limit low - forced to remove inactive and idle queue: " + container.getDestinationName()));
                }
            }
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                i = this.containers.values().iterator();
                while (i.hasNext()) {
                    container = (TransientQueueBoundedMessageContainer)i.next();
                    if (container.isActive() || !container.getDestination().isTemporary()) continue;
                    this.removeContainer(container);
                    log.warn((Object)("memory limit low - forced to remove inactive temporary queue: " + container.getDestinationName()));
                }
            }
            i = this.containers.values().iterator();
            while (i.hasNext()) {
                container = (TransientQueueBoundedMessageContainer)i.next();
                if (container.isActive() || container.isEmpty()) continue;
                this.removeContainer(container);
            }
            this.doingGarbageCollection.set(false);
        }
    }

    private synchronized void addContainer(TransientQueueBoundedMessageContainer container) {
        this.containers.put((Object)container.getDestination(), (Object)container);
        this.destinationMap.put(container.getDestination(), container);
    }

    private synchronized void removeContainer(TransientQueueBoundedMessageContainer container) {
        try {
            container.close();
            log.info((Object)("closed inactive transient queue container: " + container.getDestinationName()));
        }
        catch (JMSException e) {
            log.warn((Object)"failure closing container", (Throwable)e);
        }
        this.containers.remove((Object)container.getDestination());
        this.destinationMap.remove(container.getDestination(), container);
    }

    protected Executor getThreadPool() {
        return this.threadPool;
    }

    public void createMessageContainer(ActiveMQDestination dest) throws JMSException {
    }

    public void destroyMessageContainer(ActiveMQDestination dest) throws JMSException {
    }

    public Map getMessageContainerAdmins() throws JMSException {
        return Collections.EMPTY_MAP;
    }

    protected static class TransientQueueThreadFactory
    implements ThreadFactory {
        protected TransientQueueThreadFactory() {
        }

        public Thread newThread(Runnable command) {
            Thread result = new Thread(command);
            result.setPriority(6);
            result.setDaemon(true);
            return result;
        }
    }
}

