/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import org.codehaus.activemq.io.impl.AbstractPacketWriter;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.util.BitArray;

public class MessageAckWriter
extends AbstractPacketWriter {
    public int getPacketType() {
        return 15;
    }

    public void writePacket(Packet packet, DataOutput dataOut) throws IOException {
        super.writePacket(packet, dataOut);
        MessageAck ack = (MessageAck)packet;
        super.writeUTF(ack.getConsumerId(), dataOut);
        super.writeUTF(ack.getMessageID(), dataOut);
        super.writeUTF(ack.getTransactionId(), dataOut);
        BitArray ba = new BitArray();
        ba.set(0, ack.isMessageRead());
        ba.set(1, ack.isXaTransacted());
        ba.set(2, ack.isPersistent());
        ba.writeToStream(dataOut);
        ActiveMQDestination.writeToStream(ack.getDestination(), dataOut);
    }
}

