/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import java.io.DataInput;
import java.io.IOException;
import org.codehaus.activemq.io.impl.AbstractPacketReader;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.util.BitArray;

public class MessageAckReader
extends AbstractPacketReader {
    public int getPacketType() {
        return 15;
    }

    public Packet createPacket() {
        return new MessageAck();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        super.buildPacket(packet, dataIn);
        MessageAck ack = (MessageAck)packet;
        ack.setConsumerId(dataIn.readUTF());
        ack.setMessageID(dataIn.readUTF());
        ack.setTransactionId(dataIn.readUTF());
        BitArray ba = new BitArray();
        ba.readFromStream(dataIn);
        ack.setMessageRead(ba.get(0));
        ack.setXaTransacted(ba.get(1));
        ack.setPersistent(ba.get(2));
        ack.setDestination(ActiveMQDestination.readFromStream(dataIn));
    }
}

