/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import java.io.DataInput;
import java.io.IOException;
import org.codehaus.activemq.io.impl.AbstractPacketReader;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.util.BitArray;

public class ActiveMQMessageReader
extends AbstractPacketReader {
    public int getPacketType() {
        return 6;
    }

    public Packet createPacket() {
        return new ActiveMQMessage();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        int payloadLength;
        short cidlength;
        super.buildPacket(packet, dataIn);
        ActiveMQMessage msg = (ActiveMQMessage)packet;
        msg.setJMSClientID(super.readUTF(dataIn));
        msg.setProducerID(super.readUTF(dataIn));
        msg.setJMSDestination(ActiveMQDestination.readFromStream(dataIn));
        msg.setJMSDeliveryMode(dataIn.readByte());
        msg.setJMSPriority(dataIn.readByte());
        BitArray ba = msg.getBitArray();
        msg.setJMSRedelivered(ba.get(10));
        msg.setXaTransacted(ba.get(11));
        if (ba.get(2)) {
            msg.setJMSCorrelationID(super.readUTF(dataIn));
        }
        if (ba.get(3)) {
            msg.setJMSType(super.readUTF(dataIn));
        }
        if (ba.get(4)) {
            msg.setEntryBrokerName(super.readUTF(dataIn));
        }
        if (ba.get(5)) {
            msg.setEntryClusterName(super.readUTF(dataIn));
        }
        if (ba.get(6)) {
            msg.setTransactionId(super.readUTF(dataIn));
        }
        if (ba.get(7)) {
            msg.setJMSReplyTo(ActiveMQDestination.readFromStream(dataIn));
        }
        if (ba.get(8)) {
            msg.setJMSTimestamp(dataIn.readLong());
        }
        if (ba.get(9)) {
            msg.setJMSExpiration(dataIn.readLong());
        }
        if (ba.get(12) && (cidlength = dataIn.readShort()) > 0) {
            int[] cids = new int[cidlength];
            for (int i = 0; i < cids.length; ++i) {
                cids[i] = dataIn.readShort();
            }
            msg.setConsumerNos(cids);
        }
        if (ba.get(13)) {
            msg.setProperties(msg.readMapProperties(dataIn));
        }
        if (ba.get(15) && (payloadLength = dataIn.readInt()) >= 0) {
            byte[] payload = new byte[payloadLength];
            dataIn.readFully(payload);
            msg.setBodyAsBytes(payload);
        }
    }
}

