/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jca;

import java.lang.reflect.Method;
import javax.jms.MessageListener;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.activemq.jca.AcknowledgeEndpoint;
import org.activemq.jca.LocalTransactionEndpoint;
import org.activemq.jca.XAEndpoint;

public abstract class EndpointFactorySupport
implements MessageEndpointFactory {
    protected TransactionManager transactionManager;

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        MessageListener messageListener = this.createMessageListener();
        if (this.transactionManager != null) {
            return new XAEndpoint(messageListener, xaResource, this.transactionManager);
        }
        if (xaResource instanceof LocalTransaction) {
            return new LocalTransactionEndpoint(messageListener, (LocalTransaction)xaResource);
        }
        return new AcknowledgeEndpoint(messageListener);
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return this.transactionManager != null;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected abstract MessageListener createMessageListener() throws UnavailableException;
}

