/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jca;

import javax.jms.MessageListener;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.activemq.jca.DefaultEndpointFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JCAConnector
implements InitializingBean,
DisposableBean {
    private ActivationSpec activationSpec;
    private BootstrapContext bootstrapContext;
    private MessageEndpointFactory endpointFactory;
    private ResourceAdapter resourceAdapter;
    private MessageListener messageListener;
    private TransactionManager transactionManager;

    public JCAConnector() {
    }

    public JCAConnector(BootstrapContext bootstrapContext, ResourceAdapter resourceAdapter) {
        this.bootstrapContext = bootstrapContext;
        this.resourceAdapter = resourceAdapter;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.activationSpec == null) {
            throw new IllegalArgumentException("activationSpec must be set");
        }
        ResourceAdapter temp = this.activationSpec.getResourceAdapter();
        if (temp == null && this.resourceAdapter != null) {
            this.activationSpec.setResourceAdapter(this.resourceAdapter);
        } else if (this.resourceAdapter == null) {
            this.resourceAdapter = this.activationSpec.getResourceAdapter();
            if (this.resourceAdapter == null) {
                throw new IllegalArgumentException("resourceAdapter property must be set on the activationSpec object");
            }
        }
        if (this.bootstrapContext == null) {
            throw new IllegalArgumentException("bootstrapContext must be set");
        }
        if (this.endpointFactory == null) {
            if (this.messageListener == null) {
                throw new IllegalArgumentException("either the endpointFactory or messageListener properties must be set");
            }
            this.endpointFactory = this.transactionManager != null ? new DefaultEndpointFactory(this.messageListener, this.transactionManager) : new DefaultEndpointFactory(this.messageListener);
        }
        this.resourceAdapter.endpointActivation(this.endpointFactory, this.activationSpec);
    }

    public void destroy() throws Exception {
        if (this.resourceAdapter != null && this.activationSpec != null) {
            this.resourceAdapter.endpointDeactivation(this.endpointFactory, this.activationSpec);
        }
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public MessageEndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(MessageEndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

