/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.work;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.codehaus.activemq.work.WorkerContext;
import org.codehaus.activemq.work.XAWork;
import org.codehaus.activemq.work.pool.NullWorkExecutorPool;
import org.codehaus.activemq.work.pool.ScheduleWorkExecutor;
import org.codehaus.activemq.work.pool.StartWorkExecutor;
import org.codehaus.activemq.work.pool.SyncWorkExecutor;
import org.codehaus.activemq.work.pool.WorkExecutor;
import org.codehaus.activemq.work.pool.WorkExecutorPool;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SpringWorkManager
implements WorkManager,
InitializingBean,
DisposableBean {
    private static final int DEFAULT_POOL_SIZE = 10;
    private WorkExecutorPool syncWorkExecutorPool;
    private WorkExecutorPool startWorkExecutorPool;
    private WorkExecutorPool scheduledWorkExecutorPool;
    private final XAWork xaServices;
    private final WorkExecutor scheduleWorkExecutor = new ScheduleWorkExecutor();
    private final WorkExecutor startWorkExecutor = new StartWorkExecutor();
    private final WorkExecutor syncWorkExecutor = new SyncWorkExecutor();

    public SpringWorkManager() {
        this(10, null);
    }

    public SpringWorkManager(int size, XAWork xaServices) {
        this(size, size, size, xaServices);
    }

    public SpringWorkManager(int syncSize, int startSize, int schedSize, XAWork xaServices) {
        this.syncWorkExecutorPool = new NullWorkExecutorPool(syncSize);
        this.startWorkExecutorPool = new NullWorkExecutorPool(startSize);
        this.scheduledWorkExecutorPool = new NullWorkExecutorPool(schedSize);
        this.xaServices = xaServices;
    }

    public void afterPropertiesSet() throws Exception {
        this.syncWorkExecutorPool = this.syncWorkExecutorPool.start();
        this.startWorkExecutorPool = this.startWorkExecutorPool.start();
        this.scheduledWorkExecutorPool = this.scheduledWorkExecutorPool.start();
    }

    public void destroy() throws Exception {
        this.syncWorkExecutorPool = this.syncWorkExecutorPool.stop();
        this.startWorkExecutorPool = this.startWorkExecutorPool.stop();
        this.scheduledWorkExecutorPool = this.scheduledWorkExecutorPool.stop();
    }

    public XATerminator getXATerminator() {
        return this.xaServices;
    }

    public int getSyncThreadCount() {
        return this.syncWorkExecutorPool.getPoolSize();
    }

    public int getSyncMaximumPoolSize() {
        return this.syncWorkExecutorPool.getMaximumPoolSize();
    }

    public void setSyncMaximumPoolSize(int maxSize) {
        this.syncWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public int getStartThreadCount() {
        return this.startWorkExecutorPool.getPoolSize();
    }

    public int getStartMaximumPoolSize() {
        return this.startWorkExecutorPool.getMaximumPoolSize();
    }

    public void setStartMaximumPoolSize(int maxSize) {
        this.startWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public int getScheduledThreadCount() {
        return this.scheduledWorkExecutorPool.getPoolSize();
    }

    public int getScheduledMaximumPoolSize() {
        return this.scheduledWorkExecutorPool.getMaximumPoolSize();
    }

    public void setScheduledMaximumPoolSize(int maxSize) {
        this.scheduledWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public void doWork(Work work) throws WorkException {
        this.executeWork(new WorkerContext(work), this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.xaServices, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public long startWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.xaServices, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public void scheduleWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.xaServices, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    private void executeWork(WorkerContext work, WorkExecutor workExecutor, Executor pooledExecutor) throws WorkException {
        work.workAccepted(this);
        try {
            workExecutor.doExecute(work, pooledExecutor);
            WorkException exception = work.getWorkException();
            if (null != exception) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            WorkCompletedException wcj = new WorkCompletedException("The execution has been interrupted.", (Throwable)e);
            wcj.setErrorCode("-1");
            throw wcj;
        }
    }
}

