/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.pool;

import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.commons.pool.ObjectPool;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class PooledConnection
implements TopicConnection,
QueueConnection {
    private TopicConnection topicConnection;
    private QueueConnection queueConnection;
    private ObjectPool pool;

    public PooledConnection(TopicConnection topicConnection, ObjectPool pool) {
        this.topicConnection = topicConnection;
        this.pool = pool;
        this.queueConnection = (QueueConnection)topicConnection;
    }

    public void close() throws JMSException {
        TopicConnection tmp = this.topicConnection;
        this.topicConnection = null;
        this.queueConnection = null;
        try {
            this.pool.returnObject((Object)tmp);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.newJMSException((Throwable)e);
        }
    }

    public void start() throws JMSException {
        this.getTopicConnection().start();
    }

    public void stop() throws JMSException {
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getTopicConnection().createConnectionConsumer(destination, s, serverSessionPool, i);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getTopicConnection().createConnectionConsumer(topic, s, serverSessionPool, i);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String s, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getTopicConnection().createDurableConnectionConsumer(topic, s, s1, serverSessionPool, i);
    }

    public Session createSession(boolean b, int i) throws JMSException {
        return this.getTopicConnection().createSession(b, i);
    }

    public TopicSession createTopicSession(boolean b, int i) throws JMSException {
        return this.getTopicConnection().createTopicSession(b, i);
    }

    public String getClientID() throws JMSException {
        return this.getTopicConnection().getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getTopicConnection().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getTopicConnection().getMetaData();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getTopicConnection().setExceptionListener(exceptionListener);
    }

    public void setClientID(String s) throws JMSException {
        this.getTopicConnection().setClientID(s);
    }

    public QueueSession createQueueSession(boolean b, int i) throws JMSException {
        return this.getQueueConnection().createQueueSession(b, i);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getQueueConnection().createConnectionConsumer(queue, s, serverSessionPool, i);
    }

    protected TopicConnection getTopicConnection() throws JMSException {
        if (this.topicConnection == null) {
            throw this.createAlreadyClosedException();
        }
        return this.topicConnection;
    }

    protected QueueConnection getQueueConnection() throws JMSException {
        if (this.queueConnection == null) {
            throw this.createAlreadyClosedException();
        }
        return this.queueConnection;
    }

    protected JMSException createAlreadyClosedException() {
        return new JMSException("This connection has already been closed");
    }
}

