/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.jca;

import java.lang.reflect.Method;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.endpoint.MessageEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalTransactionEndpoint
implements MessageEndpoint,
MessageListener {
    private static final Log log = LogFactory.getLog((Class)LocalTransactionEndpoint.class);
    private MessageListener messageListener;
    private LocalTransaction localTransaction;

    public LocalTransactionEndpoint(MessageListener messageListener, LocalTransaction localTransaction) {
        this.messageListener = messageListener;
        this.localTransaction = localTransaction;
    }

    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        this.localTransaction.begin();
    }

    public void afterDelivery() throws ResourceException {
        this.localTransaction.commit();
        this.localTransaction = null;
    }

    public void release() {
        if (this.localTransaction != null) {
            try {
                this.localTransaction.rollback();
            }
            catch (ResourceException e) {
                log.warn((Object)("Failed to rollback local transaction: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public void onMessage(Message message) {
        this.messageListener.onMessage(message);
    }
}

