/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.work;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkAdapter;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.work.XAWork;

public class WorkerContext
implements Work {
    private Log log = LogFactory.getLog((Class)WorkerContext.class);
    private static final WorkListener NULL_WORK_LISTENER;
    private int threadPriority;
    private Work adaptee;
    private boolean isAccepted;
    private long acceptedTime;
    private int nbRetry;
    private long startTimeOut;
    private final ExecutionContext executionContext;
    private final XAWork xaWork;
    private WorkListener workListener = NULL_WORK_LISTENER;
    private WorkException workException;
    private Latch startLatch = new Latch();
    private Latch endLatch = new Latch();
    static final /* synthetic */ boolean $assertionsDisabled;

    public WorkerContext(Work aWork) {
        this.adaptee = aWork;
        this.executionContext = null;
        this.xaWork = null;
    }

    public WorkerContext(Work aWork, long aStartTimeout, ExecutionContext execContext, XAWork xaWork, WorkListener workListener) {
        this.adaptee = aWork;
        this.startTimeOut = aStartTimeout;
        this.executionContext = execContext;
        this.xaWork = xaWork;
        if (null != workListener) {
            this.workListener = workListener;
        }
    }

    public void release() {
        this.adaptee.release();
    }

    public void setThreadPriority(int aPriority) {
        this.threadPriority = aPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void workAccepted(Object anObject) {
        this.isAccepted = true;
        this.acceptedTime = System.currentTimeMillis();
        this.workListener.workAccepted(new WorkEvent(anObject, 1, this.adaptee, null));
    }

    public synchronized long getAcceptedTime() {
        return this.acceptedTime;
    }

    public long getStartTimeout() {
        return this.startTimeOut;
    }

    public synchronized boolean isTimedOut() {
        boolean isTimeout;
        if (!$assertionsDisabled && !this.isAccepted) {
            throw new AssertionError((Object)"The work is not accepted.");
        }
        if (0L == this.startTimeOut || this.startTimeOut == Long.MAX_VALUE) {
            return false;
        }
        boolean bl = isTimeout = this.acceptedTime + this.startTimeOut > 0L && System.currentTimeMillis() > this.acceptedTime + this.startTimeOut;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this + " accepted at " + this.acceptedTime + (isTimeout ? " has timed out." : " has not timed out. ") + this.nbRetry + " retries have been performed."));
        }
        if (isTimeout) {
            this.workException = new WorkRejectedException(this + " has timed out.", "1");
            this.workListener.workRejected(new WorkEvent((Object)this, 2, this.adaptee, this.workException));
            return true;
        }
        ++this.nbRetry;
        return isTimeout;
    }

    public synchronized WorkException getWorkException() {
        return this.workException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.isTimedOut()) {
            this.startLatch.release();
            this.endLatch.release();
            return;
        }
        this.workListener.workStarted(new WorkEvent((Object)this, 3, this.adaptee, null));
        this.startLatch.release();
        try {
            if (this.executionContext == null || this.executionContext.getXid() == null) {
                this.adaptee.run();
            } else {
                try {
                    this.xaWork.begin(this.executionContext.getXid(), this.executionContext.getTransactionTimeout());
                    this.adaptee.run();
                }
                finally {
                    this.xaWork.end(this.executionContext.getXid());
                }
            }
            this.workListener.workCompleted(new WorkEvent((Object)this, 4, this.adaptee, null));
        }
        catch (Throwable e) {
            this.workException = new WorkCompletedException(e);
            this.workListener.workRejected(new WorkEvent((Object)this, 2, this.adaptee, this.workException));
        }
        finally {
            this.endLatch.release();
        }
    }

    public synchronized Latch provideStartLatch() {
        return this.startLatch;
    }

    public synchronized Latch provideEndLatch() {
        return this.endLatch;
    }

    public String toString() {
        return "Work :" + this.adaptee;
    }

    static {
        $assertionsDisabled = !WorkerContext.class.desiredAssertionStatus();
        NULL_WORK_LISTENER = new WorkAdapter();
    }
}

