/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.taglibs.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.SecureContext;

public class AuthorizeTag
extends TagSupport {
    private String ifAllGranted = "";
    private String ifAnyGranted = "";
    private String ifNotGranted = "";

    public void setIfAllGranted(String ifAllGranted) {
        this.ifAllGranted = ifAllGranted;
    }

    public String getIfAllGranted() {
        return this.ifAllGranted;
    }

    public void setIfAnyGranted(String ifAnyGranted) {
        this.ifAnyGranted = ifAnyGranted;
    }

    public String getIfAnyGranted() {
        return this.ifAnyGranted;
    }

    public void setIfNotGranted(String ifNotGranted) {
        this.ifNotGranted = ifNotGranted;
    }

    public String getIfNotGranted() {
        return this.ifNotGranted;
    }

    public int doStartTag() throws JspException {
        Set grantedCopy;
        if (!(null != this.ifAllGranted && !"".equals(this.ifAllGranted) || null != this.ifAnyGranted && !"".equals(this.ifAnyGranted) || null != this.ifNotGranted && !"".equals(this.ifNotGranted))) {
            return 0;
        }
        Collection granted = this.getPrincipalAuthorities();
        if (null != this.ifNotGranted && !"".equals(this.ifNotGranted) && !(grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(this.ifNotGranted))).isEmpty()) {
            return 0;
        }
        if (null != this.ifAllGranted && !"".equals(this.ifAllGranted) && !granted.containsAll(this.parseAuthoritiesString(this.ifAllGranted))) {
            return 0;
        }
        if (null != this.ifAnyGranted && !"".equals(this.ifAnyGranted) && (grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(this.ifAnyGranted))).isEmpty()) {
            return 0;
        }
        return 1;
    }

    private Collection getPrincipalAuthorities() {
        SecureContext context = (SecureContext)ContextHolder.getContext();
        if (null == context) {
            return Collections.EMPTY_LIST;
        }
        Authentication currentUser = context.getAuthentication();
        if (null == currentUser) {
            return Collections.EMPTY_LIST;
        }
        List<GrantedAuthority> granted = Arrays.asList(currentUser.getAuthorities());
        return granted;
    }

    private Set parseAuthoritiesString(String authorizationsString) {
        HashSet<GrantedAuthorityImpl> requiredAuthorities = new HashSet<GrantedAuthorityImpl>();
        StringTokenizer tokenizer = new StringTokenizer(authorizationsString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String role = tokenizer.nextToken();
            requiredAuthorities.add(new GrantedAuthorityImpl(role.trim()));
        }
        return requiredAuthorities;
    }

    private Set retainAll(Collection granted, Set requiredAuthorities) {
        HashSet grantedCopy = new HashSet(granted);
        grantedCopy.retainAll(requiredAuthorities);
        return grantedCopy;
    }
}

