/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTByteArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTIntArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTLongArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.nbt.NBTType;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.StringUtils;
import org.bukkit.inventory.ItemStack;

public class ItemStackSerializer {
    public static List<String> serialize(ItemStack item) {
        NBTCompound nbt;
        String asString;
        if (!ReflectionManager.isCraftItem(item) && item.hasItemMeta()) {
            item = ReflectionManager.getCraftItem(item);
        }
        ArrayList<String> mcArray = new ArrayList<String>();
        String type = ReflectionManager.getItemName(item.getType());
        if (item.hasItemMeta() && NmsVersion.v1_13.isSupported()) {
            if (NmsVersion.v1_20_R4.isSupported()) {
                Object asJava = ReflectionManager.getNmsReflection().serializeComponents(item);
                if (asJava != null && (asString = ItemStackSerializer.serializeObj(asJava)).length() > 2) {
                    type = type + "[" + asString.substring(1, asString.length() - 1) + "]";
                }
            } else {
                nbt = DisguiseUtilities.fromBukkitItemStack(item).getNBT();
                if (nbt != null && (asString = ItemStackSerializer.serialize((NBT)nbt)).length() > 2) {
                    type = type + asString;
                }
            }
        }
        mcArray.add(type);
        if (item.getAmount() != 1) {
            mcArray.add(String.valueOf(item.getAmount()));
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (item.getDurability() != 0) {
                mcArray.add(String.valueOf(item.getDurability()));
            }
            if (item.hasItemMeta() && (nbt = DisguiseUtilities.fromBukkitItemStack(item).getNBT()) != null && (asString = ItemStackSerializer.serialize((NBT)nbt)).length() > 2) {
                mcArray.add(ItemStackSerializer.serialize((NBT)nbt));
            }
        }
        return mcArray;
    }

    public static String serialize(NBT base) {
        return ItemStackSerializer.serialize(0, base);
    }

    private static String serializeObj(Object object) {
        return ItemStackSerializer.serializeObj(0, object);
    }

    private static String serializeObj(int depth, Object object) {
        if (object instanceof Map) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String val = ItemStackSerializer.serializeObj(depth + 1, entry.getValue());
                if (depth == 0 && val.matches("0(\\.0)?")) continue;
                if (builder.length() > 1) {
                    builder.append(",");
                }
                builder.append((String)entry.getKey()).append("=").append(val);
            }
            builder.append("}");
            return builder.toString();
        }
        if (object instanceof ByteList) {
            ByteList byteArray = (ByteList)object;
            ArrayList<String> bytes = new ArrayList<String>();
            ByteListIterator entry = byteArray.iterator();
            while (entry.hasNext()) {
                byte b = (Byte)entry.next();
                bytes.add(String.valueOf(b));
            }
            return "[B;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (object instanceof IntList) {
            IntList byteArray = (IntList)object;
            ArrayList<String> bytes = new ArrayList<String>();
            IntListIterator entry = byteArray.iterator();
            while (entry.hasNext()) {
                int b = (Integer)entry.next();
                bytes.add(String.valueOf(b));
            }
            return "[I;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (object instanceof LongList) {
            LongList byteArray = (LongList)object;
            ArrayList<String> bytes = new ArrayList<String>();
            LongListIterator entry = byteArray.iterator();
            while (entry.hasNext()) {
                long b = (Long)entry.next();
                bytes.add(String.valueOf(b));
            }
            return "[L;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (object instanceof List) {
            ArrayList<String> serialized = new ArrayList<String>();
            for (Object obj : (List)object) {
                serialized.add(ItemStackSerializer.serializeObj(depth + 1, obj));
            }
            return "[" + StringUtils.join(serialized, (String)",") + "]";
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof String) {
            if (((String)object).contains("\"") && !((String)object).contains("'")) {
                return "'" + object + "'";
            }
            return "\"" + ((String)object).replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        throw new IllegalArgumentException();
    }

    private static String serialize(int depth, NBT base) {
        if (base.getType() == NBTType.COMPOUND) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (String key : ((NBTCompound)base).getTagNames()) {
                NBT nbt = ((NBTCompound)base).getTagOrThrow(key);
                String val = ItemStackSerializer.serialize(depth + 1, nbt);
                if (depth == 0 && val.matches("0(\\.0)?")) continue;
                if (builder.length() > 1) {
                    builder.append(",");
                }
                builder.append(key).append(":").append(val);
            }
            builder.append("}");
            return builder.toString();
        }
        if (base.getType() == NBTType.LIST) {
            ArrayList<String> serialized = new ArrayList<String>();
            for (NBT something : ((NBTList)base).getTags()) {
                serialized.add(ItemStackSerializer.serialize(depth + 1, something));
            }
            return "[" + StringUtils.join(serialized, (String)",") + "]";
        }
        if (base.getType() == NBTType.BYTE_ARRAY) {
            NBTByteArray byteArray = (NBTByteArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (byte b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[B;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.INT_ARRAY) {
            NBTIntArray byteArray = (NBTIntArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (int b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[I;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.LONG_ARRAY) {
            NBTLongArray byteArray = (NBTLongArray)base;
            ArrayList<String> bytes = new ArrayList<String>();
            for (long b : byteArray.getValue()) {
                bytes.add(String.valueOf(b));
            }
            return "[L;" + String.join((CharSequence)",", bytes) + "]";
        }
        if (base.getType() == NBTType.BYTE || base.getType() == NBTType.INT || base.getType() == NBTType.LONG || base.getType() == NBTType.FLOAT || base.getType() == NBTType.SHORT || base.getType() == NBTType.DOUBLE) {
            NBTNumber number = (NBTNumber)base;
            return number.getAsNumber().toString();
        }
        if (base.getType() == NBTType.STRING) {
            String val = ((NBTString)base).getValue();
            return "\"" + val.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        if (base.getType() == NBTType.END) {
            return "";
        }
        throw new IllegalArgumentException();
    }
}

