/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Location;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PacketHandlerMovement<T extends PacketWrapper<T>>
implements IPacketHandler<T> {
    private final boolean invalid = LibsPremium.getUserID().matches("\\d+") && Integer.parseInt(LibsPremium.getUserID()) < 2;

    @Override
    public PacketTypeCommon[] getHandledPackets() {
        return new PacketTypeCommon[]{PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION, PacketType.Play.Server.ENTITY_ROTATION, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_RELATIVE_MOVE};
    }

    private double conRel(double oldCord, double newCord) {
        return oldCord - newCord;
    }

    @Override
    public void handle(Disguise disguise, LibsPackets<T> packets, Player observer, Entity entity) {
        this.handleMovement(disguise, packets, observer, entity);
        this.addMultiNames(disguise, packets);
    }

    private void addMultiNames(Disguise disguise, LibsPackets<T> packets) {
        int len = disguise.getMultiNameLength();
        if (len == 0) {
            return;
        }
        ArrayList<WrapperPlayServerEntityRelativeMove> toAdd = new ArrayList<WrapperPlayServerEntityRelativeMove>();
        double height = disguise.getHeight() + (double)disguise.getWatcher().getNameYModifier();
        double heightScale = disguise.getNameHeightScale();
        height *= heightScale;
        height += DisguiseUtilities.getNameSpacing() * (heightScale - 1.0) * 0.35;
        for (PacketWrapper packet : packets.getPackets()) {
            if (packet instanceof WrapperPlayServerEntityRotation) continue;
            for (int i = 0; i < len; ++i) {
                WrapperPlayServerEntityRelativeMoveAndRotation rot;
                WrapperPlayServerEntityRelativeMove cloned;
                int standId = disguise.getArmorstandIds()[i];
                if (packet instanceof WrapperPlayServerEntityTeleport) {
                    WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)packet;
                    cloned = new WrapperPlayServerEntityTeleport(standId, tele.getPosition().add(0.0, height + DisguiseUtilities.getNameSpacing() * (double)i, 0.0), tele.getYaw(), tele.getPitch(), tele.isOnGround());
                } else if (packet instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                    rot = (WrapperPlayServerEntityRelativeMoveAndRotation)packet;
                    cloned = new WrapperPlayServerEntityRelativeMoveAndRotation(standId, rot.getDeltaX(), rot.getDeltaY(), rot.getDeltaZ(), rot.getYaw(), rot.getPitch(), rot.isOnGround());
                } else if (packet instanceof WrapperPlayServerEntityRelativeMove) {
                    rot = (WrapperPlayServerEntityRelativeMove)packet;
                    cloned = new WrapperPlayServerEntityRelativeMove(standId, rot.getDeltaX(), rot.getDeltaY(), rot.getDeltaZ(), rot.isOnGround());
                } else {
                    throw new IllegalStateException("Unknown packet " + packet.getClass());
                }
                toAdd.add(cloned);
            }
        }
        packets.getPackets().addAll(toAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMovement(Disguise disguise, LibsPackets<T> packets, Player observer, Entity entity) {
        if (this.invalid && RandomUtils.nextDouble() < 0.1) {
            packets.clear();
            return;
        }
        T sentPacket = packets.getOriginalPacket();
        double yMod = DisguiseUtilities.getYModifier(disguise) + (double)disguise.getWatcher().getYModifier();
        if (disguise.getType() == DisguiseType.FALLING_BLOCK && ((FallingBlockWatcher)disguise.getWatcher()).isGridLocked()) {
            WrapperPlayServerEntityTeleport movePacket;
            packets.clear();
            if (sentPacket instanceof WrapperPlayServerEntityRotation) {
                return;
            }
            Location loc = entity.getLocation();
            if (sentPacket instanceof WrapperPlayServerEntityTeleport) {
                WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)sentPacket;
                double y = loc.getBlockY();
                movePacket = new WrapperPlayServerEntityTeleport(tele.getEntityId(), new Vector3d((double)loc.getBlockX() + 0.5, (y += loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0)) + yMod, (double)loc.getBlockZ() + 0.5), tele.getYaw(), tele.getPitch(), tele.isOnGround());
            } else {
                boolean sameBlock;
                double z;
                double y;
                double x;
                WrapperPlayServerEntityRelativeMoveAndRotation rot;
                if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                    rot = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
                    x = rot.getDeltaX();
                    y = rot.getDeltaY();
                    z = rot.getDeltaZ();
                } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMove) {
                    rot = (WrapperPlayServerEntityRelativeMove)sentPacket;
                    x = rot.getDeltaX();
                    y = rot.getDeltaY();
                    z = rot.getDeltaZ();
                } else {
                    throw new IllegalStateException("Unknown packet " + sentPacket.getClass());
                }
                Location newLoc = loc.clone().subtract(x, y, z);
                double origY = (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
                double newY = (double)newLoc.getBlockY() + (newLoc.getY() % 1.0 >= 0.85 ? 1.0 : (newLoc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
                boolean bl = sameBlock = loc.getBlockX() == newLoc.getBlockX() && newY == origY && loc.getBlockZ() == newLoc.getBlockZ();
                if (sameBlock) {
                    return;
                }
                x = this.conRel(loc.getBlockX(), newLoc.getBlockX());
                y = this.conRel(origY, newY);
                z = this.conRel(loc.getBlockZ(), newLoc.getBlockZ());
                if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                    WrapperPlayServerEntityRelativeMoveAndRotation rot2 = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
                    movePacket = new WrapperPlayServerEntityRelativeMoveAndRotation(rot2.getEntityId(), x, y, z, rot2.getYaw(), rot2.getPitch(), rot2.isOnGround());
                } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMove) {
                    WrapperPlayServerEntityRelativeMove rot3 = (WrapperPlayServerEntityRelativeMove)sentPacket;
                    x = rot3.getDeltaX();
                    y = rot3.getDeltaY();
                    z = rot3.getDeltaZ();
                    movePacket = new WrapperPlayServerEntityRelativeMove(rot3.getEntityId(), x, y, z, rot3.isOnGround());
                } else {
                    throw new IllegalStateException("Unknown packet " + sentPacket.getClass());
                }
            }
            packets.addPacket((PacketWrapper)movePacket);
            return;
        }
        if (disguise.getType() == DisguiseType.RABBIT && (sentPacket instanceof WrapperPlayServerEntityRelativeMove || sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation)) {
            PacketHandlerMovement movePacket = this;
            synchronized (movePacket) {
                long lastHop;
                HashMap<String, Long> rabbitHops;
                if (!entity.getMetadata("LibsRabbitHop").isEmpty()) {
                    rabbitHops = (HashMap<String, Long>)((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).value();
                    Iterator iterator = rabbitHops.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if ((Long)iterator.next().getValue() + 500L > System.currentTimeMillis()) continue;
                        iterator.remove();
                    }
                } else {
                    rabbitHops = new HashMap<String, Long>();
                    entity.setMetadata("LibsRabbitHop", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), rabbitHops));
                }
                long l = lastHop = rabbitHops.containsKey(observer.getName()) ? System.currentTimeMillis() - (Long)rabbitHops.get(observer.getName()) : 99999L;
                if (lastHop < 100L || lastHop > 500L) {
                    if (lastHop > 500L) {
                        rabbitHops.put(observer.getName(), System.currentTimeMillis());
                    }
                    packets.addPacket((PacketWrapper)new WrapperPlayServerEntityStatus(entity.getEntityId(), 1));
                }
            }
        }
        if (sentPacket instanceof WrapperPlayServerEntityRotation && disguise.getType() == DisguiseType.WITHER_SKULL) {
            packets.clear();
        } else {
            if (!(sentPacket instanceof WrapperPlayServerEntityRelativeMove)) {
                WrapperPlayServerEntityTeleport tele;
                WrapperPlayServerEntityRelativeMoveAndRotation rot;
                WrapperPlayServerEntityTeleport cloned;
                float pitchValue;
                float yawValue;
                packets.clear();
                if (sentPacket instanceof WrapperPlayServerEntityTeleport) {
                    WrapperPlayServerEntityTeleport tele2 = (WrapperPlayServerEntityTeleport)sentPacket;
                    yawValue = tele2.getYaw();
                    pitchValue = tele2.getPitch();
                    cloned = new WrapperPlayServerEntityTeleport(tele2.getEntityId(), tele2.getPosition(), yawValue, pitchValue, tele2.isOnGround());
                } else if (sentPacket instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                    rot = (WrapperPlayServerEntityRelativeMoveAndRotation)sentPacket;
                    yawValue = rot.getYaw();
                    pitchValue = rot.getPitch();
                    cloned = new WrapperPlayServerEntityRelativeMoveAndRotation(rot.getEntityId(), rot.getDeltaX(), rot.getDeltaY(), rot.getDeltaZ(), yawValue, pitchValue, rot.isOnGround());
                } else if (sentPacket instanceof WrapperPlayServerEntityRotation) {
                    rot = (WrapperPlayServerEntityRotation)sentPacket;
                    yawValue = rot.getYaw();
                    pitchValue = rot.getPitch();
                    cloned = new WrapperPlayServerEntityRotation(rot.getEntityId(), yawValue, pitchValue, rot.isOnGround());
                } else {
                    throw new IllegalStateException("Unknown packet " + sentPacket.getClass());
                }
                packets.addPacket((PacketWrapper)cloned);
                Float pitchLock = disguise.getWatcher().getPitchLock();
                Float yawLock = disguise.getWatcher().getYawLock();
                pitchValue = pitchLock != null ? DisguiseUtilities.getPitch(disguise.getType(), pitchLock.floatValue()) : DisguiseUtilities.getPitch(disguise.getType(), entity.getType(), pitchValue);
                yawValue = yawLock != null ? DisguiseUtilities.getYaw(disguise.getType(), yawLock.floatValue()) : DisguiseUtilities.getYaw(disguise.getType(), entity.getType(), yawValue);
                if (cloned instanceof WrapperPlayServerEntityTeleport) {
                    tele = cloned;
                    tele.setYaw(yawValue);
                    tele.setPitch(pitchValue);
                } else if (cloned instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                    WrapperPlayServerEntityRelativeMoveAndRotation rot4 = (WrapperPlayServerEntityRelativeMoveAndRotation)cloned;
                    rot4.setYaw(yawValue);
                    rot4.setPitch(pitchValue);
                } else if (cloned instanceof WrapperPlayServerEntityRotation) {
                    WrapperPlayServerEntityRotation look = (WrapperPlayServerEntityRotation)cloned;
                    look.setYaw(yawValue);
                    look.setPitch(pitchValue);
                }
                if (entity == observer.getVehicle() && AbstractHorse.class.isAssignableFrom(disguise.getType().getEntityClass())) {
                    WrapperPlayServerEntityRotation packet = new WrapperPlayServerEntityRotation(DisguiseAPI.getEntityAttachmentId(), yawValue, pitchValue, false);
                    packets.addPacket((PacketWrapper)packet);
                } else if (cloned instanceof WrapperPlayServerEntityTeleport && disguise.getType().isArtDisplay()) {
                    tele = cloned;
                    Location loc = entity.getLocation();
                    double data = (loc.getYaw() % 360.0f + 720.0f + 45.0f) / 90.0f % 4.0f;
                    if (data % 2.0 == 0.0) {
                        tele.setPosition(new Vector3d(loc.getX(), 0.0, loc.getZ() + data == 0.0 ? -1.0 : 1.0));
                    } else {
                        tele.setPosition(new Vector3d(loc.getX() + data == 3.0 ? -1.0 : 1.0, loc.getY(), loc.getZ()));
                    }
                    double y = DisguiseUtilities.getYModifier(disguise);
                    if (y != 0.0) {
                        tele.setPosition(tele.getPosition().add(0.0, y, 0.0));
                    }
                } else if (disguise.getType() == DisguiseType.DOLPHIN) {
                    if (cloned instanceof WrapperPlayServerEntityTeleport) {
                        cloned.setOnGround(false);
                    } else if (cloned instanceof WrapperPlayServerEntityRelativeMoveAndRotation) {
                        ((WrapperPlayServerEntityRelativeMoveAndRotation)cloned).setOnGround(false);
                    } else if (cloned instanceof WrapperPlayServerEntityRotation) {
                        ((WrapperPlayServerEntityRotation)cloned).setOnGround(false);
                    }
                }
            } else if (disguise.getType() == DisguiseType.DOLPHIN) {
                packets.clear();
                WrapperPlayServerEntityRelativeMove p = (WrapperPlayServerEntityRelativeMove)sentPacket;
                WrapperPlayServerEntityRelativeMove cloned = new WrapperPlayServerEntityRelativeMove(p.getEntityId(), p.getDeltaX(), p.getDeltaY(), p.getDeltaZ(), false);
                packets.addPacket((PacketWrapper)cloned);
            }
            if (yMod != 0.0 && sentPacket instanceof WrapperPlayServerEntityTeleport) {
                PacketWrapper packet = packets.getPackets().get(0);
                WrapperPlayServerEntityTeleport tele = (WrapperPlayServerEntityTeleport)packet;
                if (packet == sentPacket) {
                    packet = new WrapperPlayServerEntityTeleport(tele.getEntityId(), tele.getPosition().add(0.0, yMod, 0.0), tele.getYaw(), tele.getPitch(), tele.isOnGround());
                    packets.clear();
                    packets.addPacket(packet);
                } else {
                    tele.setPosition(tele.getPosition().add(0.0, yMod, 0.0));
                }
            }
        }
    }
}

