/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodMappedAs;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FallingBlockWatcher
extends FlagWatcher {
    private int blockCombinedId = 1;
    private boolean gridLocked;

    public FallingBlockWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public FallingBlockWatcher clone(Disguise disguise) {
        FallingBlockWatcher watcher = (FallingBlockWatcher)super.clone(disguise);
        if (NmsVersion.v1_13.isSupported()) {
            watcher.setBlockData(this.getBlockData().clone());
        } else {
            watcher.setBlock(this.getBlock().clone());
        }
        return watcher;
    }

    public void setGridLocked(boolean gridLocked) {
        if (this.isGridLocked() == gridLocked) {
            return;
        }
        this.gridLocked = gridLocked;
        if (this.getDisguise().isDisguiseInUse() && this.getDisguise().getEntity() != null) {
            Location loc = this.getDisguise().getEntity().getLocation();
            double x = this.conRel(loc.getX(), (double)loc.getBlockX() + 0.5);
            double y = this.conRel(loc.getY(), (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0)));
            double z = this.conRel(loc.getZ(), (double)loc.getBlockZ() + 0.5);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                int entityId = this.getDisguise().getEntity() == player ? DisguiseAPI.getSelfDisguiseId() : this.getDisguise().getEntity().getEntityId();
                WrapperPlayServerEntityRelativeMove relMov = new WrapperPlayServerEntityRelativeMove(entityId, x, y, z, true);
                if (this.isGridLocked()) {
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)relMov);
                    continue;
                }
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)relMov);
            }
        }
    }

    private short conRel(double oldCord, double newCord) {
        return (short)((oldCord - newCord) * 4096.0 * (double)(this.isGridLocked() ? -1 : 1));
    }

    @Deprecated
    public ItemStack getBlock() {
        return ReflectionManager.getItemStackByCombinedId(this.getBlockCombinedId());
    }

    @Deprecated
    public void setBlock(ItemStack block) {
        if (block == null || block.getType() == null || block.getType() == Material.AIR || !block.getType().isBlock()) {
            block = new ItemStack(Material.STONE);
        }
        this.blockCombinedId = ReflectionManager.getCombinedIdByItemStack(block);
        if (!this.getDisguise().isCustomDisguiseName()) {
            this.getDisguise().setDisguiseName(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("Block") + " " + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(ReflectionManager.toReadable(block.getType().name(), " ")));
        }
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            DisguiseUtilities.refreshTrackers(this.getDisguise());
        }
    }

    @MethodMappedAs(value="getBlock")
    public WrappedBlockState getBlockState() {
        return WrappedBlockState.getByGlobalId((int)this.getBlockCombinedId());
    }

    @MethodMappedAs(value="setBlock")
    public void setBlockState(WrappedBlockState state) {
        this.setBlockCombinedId(state.getType().getName(), state.getGlobalId());
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public BlockData getBlockData() {
        return ReflectionManager.getBlockDataByCombinedId(this.getBlockCombinedId());
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setBlockData(BlockData data) {
        if (data == null || data.getMaterial() == Material.AIR && data.getMaterial().isBlock()) {
            this.setBlock(null);
            return;
        }
        this.setBlockCombinedId(data.getMaterial().name(), ReflectionManager.getCombinedIdByBlockData(data));
    }

    private void setBlockCombinedId(String materialName, int combinedId) {
        this.blockCombinedId = combinedId;
        if (!this.getDisguise().isCustomDisguiseName()) {
            this.getDisguise().setDisguiseName(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("Block") + " " + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(ReflectionManager.toReadable(materialName, " ")));
        }
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            DisguiseUtilities.refreshTrackers(this.getDisguise());
        }
    }

    public int getBlockCombinedId() {
        if (this.blockCombinedId < 1) {
            this.blockCombinedId = 1;
        }
        return this.blockCombinedId;
    }

    @Generated
    public boolean isGridLocked() {
        return this.gridLocked;
    }
}

