/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import lombok.Generated;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public enum AnimalColor {
    BLACK(DyeColor.BLACK, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"INK_SAC") : Material.getMaterial((String)"INK_SACK")),
    BLUE(DyeColor.BLUE, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"LAPIS_LAZULI") : null),
    BROWN(DyeColor.BROWN, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"COCOA_BEANS") : null),
    CYAN(DyeColor.CYAN, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"CYAN_DYE") : null),
    GRAY(DyeColor.GRAY, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"GRAY_DYE") : null),
    GREEN(DyeColor.GREEN, NmsVersion.v1_14.isSupported() ? Material.getMaterial((String)"GREEN_DYE") : Material.getMaterial((String)"CACTUS_GREEN")),
    LIGHT_BLUE(DyeColor.LIGHT_BLUE, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"LIGHT_BLUE_DYE") : null),
    LIME(DyeColor.LIME, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"LIME_DYE") : null),
    MAGENTA(DyeColor.MAGENTA, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"MAGENTA_DYE") : null),
    ORANGE(DyeColor.ORANGE, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"ORANGE_DYE") : null),
    PINK(DyeColor.PINK, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"PINK_DYE") : null),
    PURPLE(DyeColor.PURPLE, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"PURPLE_DYE") : null),
    RED(DyeColor.RED, NmsVersion.v1_14.isSupported() ? Material.getMaterial((String)"RED_DYE") : Material.getMaterial((String)"ROSE_RED")),
    LIGHT_GRAY(DyeColor.valueOf((String)(NmsVersion.v1_13.isSupported() ? "LIGHT_GRAY" : "SILVER")), NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"LIGHT_GRAY_DYE") : null),
    WHITE(DyeColor.WHITE, NmsVersion.v1_13.isSupported() ? Material.getMaterial((String)"BONE_MEAL") : null),
    YELLOW(DyeColor.YELLOW, NmsVersion.v1_14.isSupported() ? Material.getMaterial((String)"YELLOW_DYE") : Material.getMaterial((String)"DANDELION_YELLOW"));

    private final DyeColor dyeColor;
    private final Material material;

    public static AnimalColor getColorByWool(int woolId) {
        for (AnimalColor color : AnimalColor.values()) {
            if (woolId != color.getDyeColor().getWoolData()) continue;
            return color;
        }
        return null;
    }

    public static AnimalColor getColorByWool(Material carpet) {
        if (carpet == null || !carpet.name().endsWith("_WOOL") && !carpet.name().endsWith("_CARPET")) {
            return null;
        }
        String name = carpet.name().replace("_CARPET", "").replace("_WOOL", "");
        for (AnimalColor color : AnimalColor.values()) {
            if (!color.name().equals(name)) continue;
            return color;
        }
        return null;
    }

    public static AnimalColor getColorByItem(ItemStack itemStack) {
        if (NmsVersion.v1_13.isSupported()) {
            return AnimalColor.getColorByMaterial(itemStack.getType());
        }
        if (itemStack.getType().name().matches("(WOOL)|(CARPET)|(INK_SACK?)")) {
            return AnimalColor.getColorByWool(itemStack.getDurability());
        }
        return null;
    }

    public static AnimalColor getColorByMaterial(Material material) {
        for (AnimalColor color : AnimalColor.values()) {
            if (color.getDyeMaterial() != material) continue;
            return color;
        }
        return null;
    }

    public static AnimalColor getColorByDye(int dyeId) {
        for (AnimalColor color : AnimalColor.values()) {
            if (dyeId != color.getDyeColor().getDyeData()) continue;
            return color;
        }
        return null;
    }

    public static AnimalColor getColor(DyeColor dyeColor) {
        for (AnimalColor color : AnimalColor.values()) {
            if (dyeColor != color.getDyeColor()) continue;
            return color;
        }
        return null;
    }

    private AnimalColor(DyeColor color, Material material) {
        this.dyeColor = color;
        this.material = NmsVersion.v1_13.isSupported() ? material : Material.getMaterial((String)"INK_SACK");
    }

    public Material getDyeMaterial() {
        return this.material;
    }

    @Generated
    public DyeColor getDyeColor() {
        return this.dyeColor;
    }
}

