/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.watchers;

import com.google.gson.Gson;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherInfo;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;

public class DisguiseMethods {
    private final HashMap<Class<? extends FlagWatcher>, List<WatcherMethod>> watcherMethods = new HashMap();
    private final HashMap<Class<? extends Disguise>, List<WatcherMethod>> disguiseMethods = new HashMap();
    private final ArrayList<WatcherMethod> methods = new ArrayList();

    public ArrayList<WatcherMethod> getMethods(Class c) {
        ArrayList<WatcherMethod> methods = new ArrayList<WatcherMethod>();
        if (this.watcherMethods.containsKey(c)) {
            methods.addAll((Collection<WatcherMethod>)this.watcherMethods.get(c));
        }
        if (c != FlagWatcher.class) {
            methods.addAll(this.getMethods(c.getSuperclass()));
        }
        return methods;
    }

    public DisguiseMethods() {
        DisguiseConfig.loadPreConfig();
        this.loadMethods();
        this.validateMethods();
    }

    private void validateMethods() {
        for (Map.Entry<Class<? extends FlagWatcher>, List<WatcherMethod>> entry : this.watcherMethods.entrySet()) {
            for (WatcherMethod method : entry.getValue()) {
                if (method.getMappedName().equals(method.getMappedName())) continue;
                for (WatcherMethod method2 : entry.getValue()) {
                    if (method == method2 || !method.getMappedName().equalsIgnoreCase(method2.getMappedName())) continue;
                    throw new IllegalArgumentException("In " + entry.getKey() + ", " + method.getMappedName() + " wants to overload " + method2.getMappedName() + " but " + method2.getMappedName() + " well, exists. Which shouldn't be the case. It should either be unsupported version or unsupported parameter. Otherwise it shouldn't be trying to overload it");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadMethods() {
        ArrayList<String> notedSkippedParamTypes = new ArrayList<String>();
        try (InputStream stream = LibsDisguises.getInstance().getResource("METHOD_MAPPINGS");){
            WatcherInfo[] watcherInfos;
            HashMap<String, Object> classes = new HashMap<String, Object>();
            classes.put(FlagWatcher.class.getSimpleName(), FlagWatcher.class);
            block29: for (DisguiseType t : DisguiseType.values()) {
                void var8_15;
                if (t.getWatcherClass() == null) continue;
                Class<? extends FlagWatcher> clazz = t.getWatcherClass();
                while (!classes.containsKey(var8_15.getSimpleName())) {
                    classes.put(var8_15.getSimpleName(), var8_15);
                    if (var8_15 == FlagWatcher.class) continue block29;
                    Class clazz2 = ReflectionManager.getSuperClass((Class)var8_15);
                }
            }
            for (WatcherInfo watcherInfo : watcherInfos = (WatcherInfo[])new Gson().fromJson(new String(ReflectionManager.readFuzzyFully(stream), StandardCharsets.UTF_8), WatcherInfo[].class)) {
                Class watcher;
                if (!watcherInfo.isSupported() || watcherInfo.isDeprecated() && watcherInfo.getAdded() != 0 && watcherInfo.getRemoved() < 0 || (watcher = (Class)classes.get(watcherInfo.getWatcher())) == null) continue;
                Class<?> param = DisguiseMethods.parseType(watcherInfo.getParam());
                Class<?> returnType = DisguiseMethods.parseType(watcherInfo.getReturnType());
                Class<?> methodType = param == null || param == Void.TYPE ? returnType : param;
                ParamInfo paramType = ParamInfoManager.getParamInfo(methodType);
                if (paramType == null) {
                    String name;
                    String string = name = methodType.isArray() ? methodType.getComponentType().getName() + "[]" : methodType.getName();
                    if (notedSkippedParamTypes.contains(name) || LibsDisguises.getInstance().isNumberedBuild()) continue;
                    notedSkippedParamTypes.add(name);
                    DisguiseUtilities.getLogger().info("DEBUG: Skipped method using " + name + ", don't need it in experimental builds");
                    continue;
                }
                MethodType type = param == null || param == Void.TYPE ? MethodType.methodType(returnType) : MethodType.methodType(returnType, param);
                MethodHandle method = MethodHandles.publicLookup().findVirtual(watcher, watcherInfo.getMethod(), type);
                boolean[] unusableBy = new boolean[DisguiseType.values().length];
                boolean[] hiddenFor = new boolean[DisguiseType.values().length];
                for (int unusable : watcherInfo.getUnusableBy()) {
                    unusableBy[unusable] = true;
                }
                for (int unusable : watcherInfo.getHiddenFor()) {
                    hiddenFor[unusable] = true;
                }
                WatcherMethod m = new WatcherMethod(watcher, method, watcherInfo.getMappedAs(), watcherInfo.getMethod(), returnType, param, watcherInfo.isRandomDefault(), watcherInfo.isDeprecated() && watcherInfo.getAdded() == 0, unusableBy, hiddenFor);
                this.methods.add(m);
                if (m.getMappedName().startsWith("get") || m.getMappedName().equals("hasPotionEffect") || param == null || param == Void.TYPE || ParamInfoManager.getParamInfo(m) == null) continue;
                this.watcherMethods.computeIfAbsent(watcher, a -> new ArrayList()).add(m);
            }
            PlayerDisguise disguise = new PlayerDisguise("");
            ArrayList<String> extraMethods = new ArrayList<String>(Arrays.asList("setSelfDisguiseVisible", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer", "setExpires", "setNotifyBar", "setBossBarColor", "setBossBarStyle", "setTallDisguisesVisible", "setDynamicName", "setSoundGroup", "setDisguiseName", "setDeadmau5Ears"));
            if (NmsVersion.v1_21_R1.isSupported()) {
                extraMethods.add("setScalePlayerToDisguise");
            }
            block34: for (Class[] classArray : extraMethods) {
                try {
                    Class<Object> cl = Boolean.TYPE;
                    Class<Disguise> disguiseClass = Disguise.class;
                    boolean randomDefault = false;
                    switch (classArray) {
                        case "setExpires": {
                            cl = Long.TYPE;
                            break;
                        }
                        case "setNotifyBar": {
                            cl = DisguiseConfig.NotifyBar.class;
                            break;
                        }
                        case "setBossBarColor": {
                            cl = BarColor.class;
                            break;
                        }
                        case "setBossBarStyle": {
                            cl = BarStyle.class;
                            break;
                        }
                        case "setDisguiseName": {
                            randomDefault = true;
                            cl = String.class;
                            break;
                        }
                        case "setSoundGroup": {
                            cl = String.class;
                            break;
                        }
                        case "setDeadmau5Ears": {
                            disguiseClass = PlayerDisguise.class;
                            break;
                        }
                    }
                    for (Class returnType : new Class[]{Void.TYPE, disguiseClass}) {
                        try {
                            WatcherMethod method = new WatcherMethod(disguiseClass, MethodHandles.publicLookup().findVirtual(disguiseClass, (String)classArray, MethodType.methodType(returnType, cl)), (String)classArray, (String)classArray, null, cl, randomDefault, false, new boolean[DisguiseType.values().length], new boolean[DisguiseType.values().length]);
                            this.methods.add(method);
                            this.watcherMethods.computeIfAbsent(disguiseClass == Disguise.class ? FlagWatcher.class : PlayerWatcher.class, a -> new ArrayList()).add(method);
                            String getName = (cl == Boolean.TYPE ? "is" : "get") + classArray.substring(3);
                            boolean[] hiddenFor = new boolean[DisguiseType.values().length];
                            if (classArray.equals("setScalePlayerToDisguise") && !LibsPremium.isPremium().booleanValue()) {
                                Arrays.fill(hiddenFor, true);
                            }
                            WatcherMethod getMethod = new WatcherMethod(disguiseClass, MethodHandles.publicLookup().findVirtual(disguiseClass, getName, MethodType.methodType(cl)), getName, getName, cl, null, randomDefault, false, new boolean[DisguiseType.values().length], hiddenFor);
                            this.methods.add(getMethod);
                            continue block34;
                        }
                        catch (NoSuchMethodException ex) {
                            if (returnType != disguiseClass) continue;
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Class<?> parseType(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.contains(".")) {
            return Class.forName(className);
        }
        switch (className) {
            case "void": {
                return Void.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "[I": {
                return int[].class;
            }
            case "[Z": {
                return boolean[].class;
            }
        }
        throw new IllegalArgumentException("Class not found: " + className);
    }

    public ArrayList<WatcherMethod> getMethods() {
        return this.methods;
    }
}

