/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;

public class MineSkinAPI {
    private long nextRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean debugging;
    private String apiKey;
    private static long lastErrorPage;

    public boolean isInUse() {
        return this.lock.isLocked();
    }

    public int nextRequestIn() {
        long timeTillNext = this.nextRequest - System.currentTimeMillis();
        if (timeTillNext < 0L) {
            return 0;
        }
        return (int)Math.ceil((double)timeTillNext / 1000.0);
    }

    public MineSkinResponse generateFromUrl(SkinUtils.SkinCallback callback, String url, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/url", url, null, modelType);
    }

    private void printDebug(String message) {
        if (!this.isDebugging() || LibsDisguises.getInstance() == null) {
            return;
        }
        LibsDisguises.getInstance().getLogger().info("[MineSkinAPI] " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MineSkinResponse doPost(SkinUtils.SkinCallback callback, String path, String skinUrl, File file, SkinUtils.ModelType modelType) {
        block70: {
            block69: {
                block67: {
                    block68: {
                        block63: {
                            block66: {
                                block65: {
                                    block64: {
                                        this.lock.lock();
                                        sleep = this.nextRequest - System.currentTimeMillis();
                                        if (file != null) {
                                            this.printDebug("Grabbing a skin from file at " + file.getPath());
                                        } else if (skinUrl != null) {
                                            this.printDebug("Grabbing a skin from url '" + skinUrl + "'");
                                        }
                                        if (this.getApiKey() != null) {
                                            this.printDebug("Using a MineSkin api key!");
                                        }
                                        if (sleep > 0L) {
                                            this.printDebug("Sleeping for " + sleep + "ms before calling the API due to a recent request");
                                            try {
                                                Thread.sleep(sleep);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        connection = null;
                                        nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
                                        if (this.getApiKey() != null) {
                                            path = path + (path.contains("?") != false ? '&' : '?') + "key=" + this.getApiKey();
                                        }
                                        url = new URL("https://api.mineskin.org" + path);
                                        connection = (HttpURLConnection)url.openConnection();
                                        connection.setConnectTimeout(19000);
                                        connection.setReadTimeout(19000);
                                        connection.setDoOutput(true);
                                        connection.setRequestProperty("User-Agent", "LibsDisguises");
                                        boundary = "LD@" + Long.toHexString(System.currentTimeMillis());
                                        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                        charset = "UTF-8";
                                        CRLF = "\r\n";
                                        output = connection.getOutputStream();
                                        try {
                                            writer = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);
                                            try {
                                                writer.append("--").append(boundary).append(CRLF);
                                                writer.append("Content-Disposition: form-data; name=\"visibility\"").append(CRLF);
                                                writer.append("Content-Type: text/plain; charset=").append(charset).append(CRLF);
                                                writer.append(CRLF).append("1").append(CRLF).flush();
                                                if (file != null) {
                                                    writer.append("--").append(boundary).append(CRLF);
                                                    writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(file.getName()).append("\"").append(CRLF);
                                                    writer.append("Content-Type: image/png").append(CRLF);
                                                    writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                                                    writer.append(CRLF).flush();
                                                    Files.copy(file.toPath(), output);
                                                    output.flush();
                                                    writer.append(CRLF).flush();
                                                } else if (skinUrl != null) {
                                                    writer.append("--").append(boundary).append(CRLF);
                                                    writer.append("Content-Disposition: form-data; name=\"url\"").append(CRLF);
                                                    writer.append(CRLF).append(skinUrl).append(CRLF).flush();
                                                }
                                                if (modelType == SkinUtils.ModelType.SLIM) {
                                                    writer.append("--").append(boundary).append(CRLF);
                                                    writer.append("Content-Disposition: form-data; name=\"variant\"").append(CRLF);
                                                    writer.append(CRLF).append("slim").append(CRLF).flush();
                                                }
                                                writer.append("--").append(boundary).append("--").append(CRLF).flush();
                                            }
                                            finally {
                                                writer.close();
                                            }
                                        }
                                        finally {
                                            if (output != null) {
                                                output.close();
                                            }
                                        }
                                        this.printDebug("Received status code: " + connection.getResponseCode());
                                        if (connection.getResponseCode() != 500) break block63;
                                        errorMessage = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                        error = (APIError)new Gson().fromJson(errorMessage, APIError.class);
                                        this.printDebug("Received error: " + errorMessage);
                                        if (error.code != 403) break block64;
                                        callback.onError(LibsMsg.SKIN_API_FAIL_CODE, new Object[]{"" + error.code, LibsMsg.SKIN_API_403.get(new Object[0])});
                                        var17_28 = null;
                                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                        this.lock.unlock();
                                        if (connection == null) return var17_28;
                                        connection.disconnect();
                                        return var17_28;
                                    }
                                    if (error.code != 404) break block65;
                                    callback.onError(LibsMsg.SKIN_API_FAIL_CODE, new Object[]{"" + error.code, LibsMsg.SKIN_API_404.get(new Object[0])});
                                    var17_29 = null;
                                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                    this.lock.unlock();
                                    if (connection == null) return var17_29;
                                    connection.disconnect();
                                    return var17_29;
                                }
                                if (error.code != 408 && error.code != 504 && error.code != 599) break block66;
                                callback.onError(LibsMsg.SKIN_API_FAIL_CODE, new Object[]{"" + error.code, LibsMsg.SKIN_API_TIMEOUT.get(new Object[0])});
                                var17_30 = null;
                                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                                this.lock.unlock();
                                if (connection == null) return var17_30;
                                connection.disconnect();
                                return var17_30;
                            }
                            callback.onError(LibsMsg.SKIN_API_FAIL_CODE, new Object[]{"" + error.code, LibsMsg.SKIN_API_IMAGE_HAS_ERROR.get(new Object[]{error.error})});
                            var17_31 = null;
                            this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                            this.lock.unlock();
                            if (connection == null) return var17_31;
                            connection.disconnect();
                            return var17_31;
                        }
                        if (connection.getResponseCode() != 400) break block67;
                        if (skinUrl == null) break block68;
                        callback.onError(LibsMsg.SKIN_API_BAD_URL, new Object[0]);
                        errorMessage = null;
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                        if (connection == null) return errorMessage;
                        connection.disconnect();
                        return errorMessage;
                    }
                    if (file == null) break block69;
                    callback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                    errorMessage = null;
                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                    this.lock.unlock();
                    if (connection == null) return errorMessage;
                    connection.disconnect();
                    return errorMessage;
                }
                if (connection.getResponseCode() != 429) break block69;
                callback.onError(LibsMsg.SKIN_API_FAIL_TOO_FAST, new Object[0]);
                errorMessage = null;
                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                this.lock.unlock();
                if (connection == null) return errorMessage;
                connection.disconnect();
                return errorMessage;
            }
            input = connection.getInputStream();
            response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            this.printDebug("Received: " + response);
            skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
            nextRequestIn = (long)(skinResponse.getNextRequest() * 1000.0);
            var18_35 = skinResponse;
            if (input == null) break block70;
            input.close();
        }
        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
        this.lock.unlock();
        if (connection == null) return var18_35;
        connection.disconnect();
        return var18_35;
        {
            catch (Throwable var16_25) {
                try {
                    if (input == null) throw var16_25;
                    try {
                        input.close();
                        throw var16_25;
                    }
                    catch (Throwable var17_33) {
                        var16_25.addSuppressed(var17_33);
                    }
                    throw var16_25;
                }
                catch (SocketTimeoutException ex) {
                    if (this.isDebugging()) {
                        ex.printStackTrace();
                    }
                    callback.onError(skinUrl == null ? LibsMsg.SKIN_API_TIMEOUT_ERROR : LibsMsg.SKIN_API_IMAGE_TIMEOUT, new Object[0]);
                    boundary = null;
                    this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                    this.lock.unlock();
                    if (connection == null) return boundary;
                    connection.disconnect();
                    return boundary;
                }
                catch (Exception ex) {
                    block71: {
                        if (connection == null) ** GOTO lbl231
                        code = connection.getResponseCode();
                        if (connection.getResponseCode() != 524 && connection.getResponseCode() != 408 && connection.getResponseCode() != 504 && connection.getResponseCode() != 599) break block71;
                        if (this.getApiKey() != null && connection.getResponseCode() == 504) {
                            callback.onError(LibsMsg.SKIN_API_TIMEOUT_API_KEY_ERROR, new Object[0]);
                        } else {
                            callback.onError(LibsMsg.SKIN_API_TIMEOUT_ERROR, new Object[0]);
                        }
                        charset = null;
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                        if (connection == null) return charset;
                        connection.disconnect();
                        return charset;
                    }
                    try {
                        block73: {
                            break block73;
                            {
                                catch (IOException code) {
                                    // empty catch block
                                }
                            }
                        }
                        if (DisguiseUtilities.getLogger() != null) {
                            try {
                                errorStream = connection.getErrorStream();
                                try {
                                    response = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                    if (response.toLowerCase(Locale.ENGLISH).contains("challenge") && response.toLowerCase(Locale.ENGLISH).contains("javascript")) {
                                        DisguiseUtilities.getLogger().warning("We may have encountered a Cloudflare challenge page while connecting to MineSkin, unfortunately this could be of several reasons. Foremost is the site suffering a bot attack, your IP could be blacklisted, there could be a Cloudflare misconfiguration.");
                                    }
                                    if (response.length() < 10000 || MineSkinAPI.lastErrorPage + TimeUnit.HOURS.toMillis(12L) < System.currentTimeMillis()) {
                                        DisguiseUtilities.getLogger().warning("MineSkin error: " + response);
                                        MineSkinAPI.lastErrorPage = System.currentTimeMillis();
                                    } else {
                                        DisguiseUtilities.getLogger().warning("MineSkin error logging skipped as it has been printed in the last 12h and is spammy");
                                    }
                                }
                                finally {
                                    if (errorStream != null) {
                                        errorStream.close();
                                    }
                                }
                            }
                            catch (IOException var12_17) {
                                // empty catch block
                            }
                        }
                        if (DisguiseUtilities.getLogger() != null) {
                            DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                        }
                        ex.printStackTrace();
                        callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                        return null;
                    }
                    catch (Throwable var19_36) {
                        throw var19_36;
                    }
                    finally {
                        this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                        this.lock.unlock();
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MineSkinResponse generateFromUUID(UUID uuid, SkinUtils.ModelType modelType) throws IllegalArgumentException {
        block18: {
            this.lock.lock();
            long sleep = this.nextRequest - System.currentTimeMillis();
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            long nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
            try {
                MineSkinResponse mineSkinResponse;
                block17: {
                    String siteUrl = "https://api.mineskin.org/generate/user/:" + uuid.toString();
                    if (modelType == SkinUtils.ModelType.SLIM) {
                        siteUrl = siteUrl + "?model=slim";
                    }
                    URL url = new URL(siteUrl);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestProperty("User-Agent", "LibsDisguises");
                    con.setDoOutput(true);
                    InputStream input = con.getInputStream();
                    try {
                        String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
                        nextRequestIn = (long)(skinResponse.getNextRequest() * 1000.0);
                        con.disconnect();
                        mineSkinResponse = skinResponse;
                        if (input == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            if (ex.getMessage() != null && ex.getMessage().contains("Server returned HTTP response code: 400 for URL")) {
                                throw new IllegalArgumentException();
                            }
                            if (DisguiseUtilities.getLogger() != null) {
                                DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                            }
                            ex.printStackTrace();
                            break block18;
                        }
                    }
                    input.close();
                }
                return mineSkinResponse;
            }
            finally {
                this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
                this.lock.unlock();
            }
        }
        return null;
    }

    public MineSkinResponse generateFromFile(SkinUtils.SkinCallback callback, File file, SkinUtils.ModelType modelType) {
        return this.doPost(callback, "/generate/upload", null, file, modelType);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private class APIError {
        int code;
        String error;

        private APIError() {
        }
    }
}

