/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.entity.Parrot;
import org.bukkit.inventory.MainHand;

public class PlayerWatcher
extends LivingWatcher {
    private boolean alwaysShowInTab = DisguiseConfig.isShowDisguisedPlayersInTab();

    public PlayerWatcher(Disguise disguise) {
        super(disguise);
        this.setData(MetaIndex.PLAYER_SKIN, MetaIndex.PLAYER_SKIN.getDefault());
        this.setData(MetaIndex.PLAYER_HAND, (byte)1);
    }

    public boolean isDisplayedInTab() {
        return this.alwaysShowInTab;
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        if (this.getDisguise().isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.alwaysShowInTab = showPlayerInTab;
    }

    public boolean isNameVisible() {
        return ((PlayerDisguise)this.getDisguise()).isNameVisible();
    }

    public void setNameVisible(boolean nameVisible) {
        ((PlayerDisguise)this.getDisguise()).setNameVisible(nameVisible);
    }

    public String getName() {
        return ((PlayerDisguise)this.getDisguise()).getName();
    }

    @RandomDefaultValue
    public void setName(String name) {
        ((PlayerDisguise)this.getDisguise()).setName(name);
    }

    public String getTablistName() {
        return ((PlayerDisguise)this.getDisguise()).getTablistName();
    }

    @RandomDefaultValue
    public void setTablistName(String tablistName) {
        ((PlayerDisguise)this.getDisguise()).setTablistName(tablistName);
    }

    @Override
    public PlayerWatcher clone(Disguise disguise) {
        PlayerWatcher watcher = (PlayerWatcher)super.clone(disguise);
        watcher.alwaysShowInTab = this.alwaysShowInTab;
        return watcher;
    }

    public MainHand getMainHand() {
        return MainHand.values()[this.getData(MetaIndex.PLAYER_HAND)];
    }

    public void setMainHand(MainHand mainHand) {
        this.setData(MetaIndex.PLAYER_HAND, (byte)mainHand.ordinal());
        this.sendData(MetaIndex.PLAYER_HAND);
    }

    private boolean isSkinFlag(int i) {
        return (this.getData(MetaIndex.PLAYER_SKIN) & 1 << i) != 0;
    }

    public boolean isCapeEnabled() {
        return this.isSkinFlag(1);
    }

    public void setCapeEnabled(boolean enabled) {
        this.setSkinFlags(0, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isJacketEnabled() {
        return this.isSkinFlag(1);
    }

    public void setJacketEnabled(boolean enabled) {
        this.setSkinFlags(1, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isLeftSleeveEnabled() {
        return this.isSkinFlag(2);
    }

    public void setLeftSleeveEnabled(boolean enabled) {
        this.setSkinFlags(2, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isRightSleeveEnabled() {
        return this.isSkinFlag(3);
    }

    public void setRightSleeveEnabled(boolean enabled) {
        this.setSkinFlags(3, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isLeftPantsEnabled() {
        return this.isSkinFlag(4);
    }

    public void setLeftPantsEnabled(boolean enabled) {
        this.setSkinFlags(4, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isRightPantsEnabled() {
        return this.isSkinFlag(5);
    }

    public void setRightPantsEnabled(boolean enabled) {
        this.setSkinFlags(5, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isHatEnabled() {
        return this.isSkinFlag(6);
    }

    public void setHatEnabled(boolean enabled) {
        this.setSkinFlags(6, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public UserProfile getSkin() {
        return ((PlayerDisguise)this.getDisguise()).getUserProfile();
    }

    public void setSkin(String playerName) {
        ((PlayerDisguise)this.getDisguise()).setSkin(playerName);
    }

    @RandomDefaultValue
    public void setSkin(UserProfile profile) {
        ((PlayerDisguise)this.getDisguise()).setSkin(profile);
    }

    private void setSkinFlags(int i, boolean flag) {
        byte b0 = this.getData(MetaIndex.PLAYER_SKIN);
        if (flag) {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 | 1 << i));
        } else {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 & ~(1 << i)));
        }
    }

    public Parrot.Variant getRightShoulderParrot() {
        return this.getParrot(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY);
    }

    public void setRightShoulderParrot(Parrot.Variant variant) {
        this.setParrot(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY, variant);
    }

    public Parrot.Variant getLeftShoulderParrot() {
        return this.getParrot(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY);
    }

    public void setLeftShoulderParrot(Parrot.Variant variant) {
        this.setParrot(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY, variant);
    }

    public boolean isRightShoulderHasParrot() {
        return this.getData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY).getStringTagOrNull("id") != null;
    }

    public void setRightShoulderHasParrot(boolean hasParrot) {
        if (this.isRightShoulderHasParrot() == hasParrot) {
            return;
        }
        if (hasParrot) {
            this.setRightShoulderParrot(Parrot.Variant.RED);
        } else {
            this.setRightShoulderParrot(null);
        }
    }

    public boolean isLeftShoulderHasParrot() {
        return this.getData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY).getStringTagOrNull("id") != null;
    }

    public void setLeftShoulderHasParrot(boolean hasParrot) {
        if (this.isLeftShoulderHasParrot() == hasParrot) {
            return;
        }
        if (hasParrot) {
            this.setLeftShoulderParrot(Parrot.Variant.RED);
        } else {
            this.setLeftShoulderParrot(null);
        }
    }

    private Parrot.Variant getParrot(MetaIndex<NBTCompound> meta) {
        NBTCompound nbt = this.getData(meta);
        NBTNumber number = nbt.getNumberTagOrNull("Variant");
        if (number == null) {
            return Parrot.Variant.RED;
        }
        return Parrot.Variant.values()[number.getAsInt()];
    }

    private void setParrot(MetaIndex<NBTCompound> meta, Parrot.Variant variant) {
        NBTCompound nbt = new NBTCompound();
        if (variant != null) {
            nbt.setTag("id", (NBT)new NBTString("minecraft:parrot"));
            nbt.setTag("Variant", (NBT)new NBTInt(variant.ordinal()));
        }
        this.setData(meta, nbt);
        this.sendData(meta);
    }
}

