/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.interactions.CopyDisguiseInteraction;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CopyDisguiseCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        Disguise disguise;
        Entity target;
        if (!(!(sender instanceof Player) || sender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            sender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        if (!sender.hasPermission("libsdisguises.copydisguise")) {
            LibsMsg.NO_PERM.send(sender, new Object[0]);
            return true;
        }
        Entity entity = target = sender instanceof Player ? (Entity)sender : null;
        if (args.length > 0) {
            target = Bukkit.getPlayer((String)args[0]);
            if (target == null && args[0].contains("-")) {
                try {
                    target = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (target == null) {
                LibsMsg.CANNOT_FIND_PLAYER.send(sender, args[0]);
                return true;
            }
        }
        if ((disguise = DisguiseAPI.getDisguise(target)) == null) {
            LibsDisguises.getInstance().getListener().addInteraction(sender.getName(), new CopyDisguiseInteraction(this), DisguiseConfig.getDisguiseEntityExpire());
            LibsMsg.DISGUISECOPY_INTERACT.send(sender, DisguiseConfig.getDisguiseEntityExpire());
            return true;
        }
        String disguiseString = DisguiseParser.parseToString(disguise, false);
        this.sendMessage(sender, LibsMsg.CLICK_TO_COPY, LibsMsg.COPY_DISGUISE_NO_COPY, disguiseString, false);
        if (disguise instanceof PlayerDisguise) {
            this.sendMessage(sender, LibsMsg.CLICK_TO_COPY_WITH_SKIN, LibsMsg.CLICK_TO_COPY_WITH_SKIN_NO_COPY, DisguiseParser.parseToString(disguise), true);
        }
        DisguiseUtilities.setCopyDisguiseCommandUsed();
        return true;
    }

    private Component createComponent(String text, int section, int max) {
        Component component = LibsMsg.CLICK_COPY.getAdv(section);
        component = NmsVersion.v1_15.isSupported() ? component.clickEvent(ClickEvent.copyToClipboard((String)text)) : component.clickEvent(ClickEvent.suggestCommand((String)text));
        LibsMsg hover = NmsVersion.v1_15.isSupported() ? LibsMsg.CLICK_TO_COPY_HOVER_CLIPBOARD : LibsMsg.CLICK_TO_COPY_HOVER;
        Component hoverText = hover.getAdv(section, max, DisguiseUtilities.getMiniMessage().escapeTags(text));
        component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText));
        return component;
    }

    public void sendMessage(CommandSender sender, LibsMsg msg, LibsMsg oldVer, String string, boolean forceAbbrev) {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append(msg.getAdv(new Object[0]))).appendSpace();
        if (string.length() > 256 || forceAbbrev) {
            int i;
            int i2;
            String[] split = DisguiseUtilities.split(string);
            for (i2 = 0; i2 < split.length; ++i2) {
                split[i2] = DisguiseUtilities.quote(split[i2]);
            }
            for (i2 = 0; i2 < split.length; ++i2) {
                if (split[i2].length() <= 256) continue;
                split = Arrays.copyOf(split, split.length + 1);
                for (int a = split.length - 1; a > i2; --a) {
                    split[a] = split[a - 1];
                }
                split[i2 + 1] = split[i2].substring(256);
                split[i2] = split[i2].substring(0, 256);
            }
            ArrayList<String> sections = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            for (i = 0; i < split.length; ++i) {
                if (current.length() > 0) {
                    current.append(" ");
                }
                current.append(split[i]);
                if (split.length > i + 1 && split[i + 1].length() + current.length() + 1 <= 256) continue;
                if (i + 1 < split.length) {
                    current.append(" ");
                }
                sections.add(current.toString());
                current = new StringBuilder();
            }
            for (i = 0; i < sections.size(); ++i) {
                if (i > 0) {
                    builder.appendSpace();
                }
                builder.append(this.createComponent((String)sections.get(i), i + 1, sections.size()));
            }
        } else {
            builder.append(this.createComponent(string, 1, 1));
        }
        DisguiseUtilities.sendMessage(sender, (Component)builder.build());
    }
}

