/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.LibsDisguisesCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.disguise.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseEntityCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguisePlayerCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.utils.CopyDisguiseCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseCloneCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseHelpCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseViewBarCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseViewSelfCommand;
import me.libraryaddict.disguise.commands.utils.GrabHeadCommand;
import me.libraryaddict.disguise.commands.utils.GrabSkinCommand;
import me.libraryaddict.disguise.commands.utils.SaveDisguiseCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.config.DisguiseCommandConfig;
import me.libraryaddict.disguise.utilities.listeners.DisguiseListener;
import me.libraryaddict.disguise.utilities.listeners.DisguiseListener1_18;
import me.libraryaddict.disguise.utilities.listeners.PaperDisguiseListener;
import me.libraryaddict.disguise.utilities.listeners.PlayerSkinHandler;
import me.libraryaddict.disguise.utilities.metrics.MetricsInitalizer;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.ClassMappings;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundManager;
import me.libraryaddict.disguise.utilities.updates.PacketEventsUpdater;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import me.libraryaddict.disguise.utilities.watchers.CompileMethods;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class LibsDisguises
extends JavaPlugin {
    private static LibsDisguises instance;
    private DisguiseListener listener;
    private String buildNumber;
    private String buildDate;
    private boolean reloaded;
    private final UpdateChecker updateChecker = new UpdateChecker();
    private PlayerSkinHandler skinHandler;
    private DisguiseCommandConfig commandConfig;
    private boolean packetEventsUpdateDownloaded;

    public void onLoad() {
        try {
            Object reason;
            boolean hasInstanceAlready;
            boolean bl = hasInstanceAlready = instance != null;
            if (hasInstanceAlready || !Bukkit.getServer().getWorlds().isEmpty() || !Bukkit.getOnlinePlayers().isEmpty()) {
                this.reloaded = true;
                this.getLogger().severe("Server was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
            }
            instance = this;
            Plugin plugin = Bukkit.getPluginManager().getPlugin("packetevents");
            if (plugin == null) {
                if (DisguiseConfig.isNeverUpdatePacketEvents()) {
                    this.getLogger().warning("Defined in plugins/LibsDisguises/configs/sanity.yml, you have requested that Lib's Disguises never updates or installs PacketEvents. Please do not report any issues with this plugin.");
                } else {
                    reason = this.getPacketEventsFailedReason(plugin);
                    this.getLogger().warning("An issue occured when trying to load PacketEvents: " + (String)reason + ". Lib's Disguises will attempt to update it.");
                    try {
                        PacketEventsUpdater updater = new PacketEventsUpdater();
                        boolean attempt = updater.doUpdate();
                        if (!attempt) {
                            this.getLogger().severe("PacketEvents download has failed, please install PacketEvents manually from https://www.spigotmc.org/resources/packetevents-api.80279/");
                        } else if (plugin == null) {
                            this.getLogger().info("PacketEvents downloaded and stuck in plugins folder! Now trying to load it!");
                            plugin = Bukkit.getPluginManager().loadPlugin(updater.getDestination());
                            plugin.onLoad();
                            Bukkit.getPluginManager().enablePlugin(plugin);
                        } else {
                            this.getLogger().severe("Please restart the server to complete the PacketEvents update!");
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().severe("Looks like PacketEvents's site may be down! Try download it manually from https://www.spigotmc.org/resources/packetevents-api.80279/");
                        e.printStackTrace();
                    }
                }
            }
            try {
                reason = Class.forName("org.bukkit.Server$Spigot");
            }
            catch (ClassNotFoundException e) {
                this.getLogger().severe("Oh dear, you seem to be using CraftBukkit. Please upgrade to use Spigot or Paper instead! This plugin will continue to load, but it will look like a mugging victim");
            }
            if (Bukkit.getVersion().toLowerCase(Locale.ENGLISH).matches(".*(arclight|mohist|magma).*")) {
                this.getLogger().severe("Lib's Disguises will not work correctly on Forge/Hybrid servers, due to complexibility and time commitment there is no support for this. Do not report any issues to Lib's Disguises.");
            }
            this.commandConfig = new DisguiseCommandConfig();
            if (!hasInstanceAlready) {
                this.commandConfig.load();
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.isNumberedBuild() && DisguiseConfig.isAutoUpdate()) {
                    this.getUpdateChecker().doUpdate();
                }
            }
            catch (Throwable t) {
                this.getLogger().severe("Failed to even do a forced update");
            }
            throw throwable;
        }
    }

    public void onEnable() {
        try {
            if (this.isReloaded()) {
                this.getLogger().severe("Server was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
            }
            this.runWarnings();
            this.updateOldDisguisesYaml();
            this.loadYamlWarnVirus();
            this.logInfo();
            DisguiseConfig.loadInternalConfig();
            LibsPremium.check(this.getDescription().getVersion(), this.getFile());
            this.someMoreLogging();
            if (ReflectionManager.getVersion() == null) {
                this.getLogger().severe("You're using the wrong version of Lib's Disguises for your server! This is intended for " + StringUtils.join((Collection)Arrays.stream(NmsVersion.values()).filter(v -> v != NmsVersion.UNSUPPORTED).map(v -> String.join((CharSequence)", ", v.getSupportedVersions())).collect(Collectors.toList()), (String)", ") + "!");
                this.getPluginLoader().disablePlugin((Plugin)this);
                return;
            }
            this.startOutdatedPacketevents();
            if (this.isReleaseBuild()) {
                if (LibsPremium.getUserID().matches("\\d+")) {
                    DisguiseConfig.setUsingReleaseBuilds(true);
                }
            } else {
                DisguiseConfig.setUsingReleaseBuilds(false);
            }
            this.runBackendStuff();
            DisguiseConfig.loadConfig();
            this.registerListeners();
            this.registerCommands();
            new MetricsInitalizer();
        }
        catch (Throwable throwable) {
            try {
                if (this.isNumberedBuild() && DisguiseConfig.isAutoUpdate()) {
                    this.getUpdateChecker().doUpdate();
                }
            }
            catch (Throwable t) {
                this.getLogger().severe("Lib's Disguises couldn't update itself");
            }
            throw throwable;
        }
    }

    private void runBackendStuff() {
        ClassMappings.loadMappingsCache(this.getDataFolder());
        if (SpigotReflectionUtil.VERSION == null) {
            SpigotReflectionUtil.init();
        }
        ReflectionManager.init();
        PacketsManager.init();
        DisguiseUtilities.init();
        new SoundManager().load();
        ReflectionManager.registerValues();
        DisguiseParser.createDefaultMethods();
        ParamInfoManager.getParamInfoSoundGroup().recalculate();
    }

    private void registerListeners() {
        PacketsManager.addPacketListeners();
        this.listener = new DisguiseListener(this);
        this.skinHandler = new PlayerSkinHandler();
        Bukkit.getPluginManager().registerEvents((Listener)this.getSkinHandler(), (Plugin)LibsDisguises.getInstance());
        if (NmsVersion.v1_18.isSupported()) {
            Bukkit.getPluginManager().registerEvents((Listener)new DisguiseListener1_18(), (Plugin)this);
        }
        if (DisguiseUtilities.isRunningPaper()) {
            Bukkit.getPluginManager().registerEvents((Listener)new PaperDisguiseListener(), (Plugin)this);
        }
    }

    @NotNull
    private String getPacketEventsFailedReason(Plugin plugin) {
        if (plugin == null) {
            return "PacketEvents not installed";
        }
        if (!plugin.isEnabled()) {
            return "PacketEvents is not enabled";
        }
        if (DisguiseUtilities.isPacketEventsOutdated()) {
            return "PacketEvents is outdated";
        }
        return "Lib's Disguises couldn't access PacketEvents properly";
    }

    private void runWarnings() {
        if (Bukkit.getVersion().contains("(MC: 1.17)")) {
            this.getLogger().severe("Please update from MC 1.17! You should be using 1.17.1!");
        }
        if (Bukkit.getVersion().contains("(MC: 1.18)") || Bukkit.getVersion().contains("(MC: 1.18.1)")) {
            this.getLogger().severe("Please update from MC 1.18 and MC 1.18.1! You should be using 1.18.2! Support will eventually be dropped for your specific version!");
        }
        if (Bukkit.getVersion().contains("(MC: 1.19)")) {
            this.getLogger().severe("Please update from MC 1.19.0! You should be using at least 1.19.3! 1.19.1 is the lowest supported 1.19 version!");
        }
        try {
            Class<?> clazz = Class.forName("org.bukkit.Server$Spigot");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe("Oh dear, you seem to be using CraftBukkit. Please use Spigot or Paper instead! This plugin will continue to load, but it will look like a mugging victim");
        }
    }

    private void updateOldDisguisesYaml() {
        File disguiseFile = new File(this.getDataFolder(), "configs/disguises.yml");
        if (!disguiseFile.exists()) {
            disguiseFile.getParentFile().mkdirs();
            File oldFile = new File(this.getDataFolder(), "disguises.yml");
            if (oldFile.exists()) {
                oldFile.renameTo(disguiseFile);
            } else {
                this.saveResource("configs/disguises.yml", false);
            }
        }
    }

    private void loadYamlWarnVirus() throws IOException {
        int expected;
        YamlConfiguration pluginYml = ReflectionManager.getPluginYAML(this.getFile());
        this.buildNumber = StringUtils.stripToNull((String)pluginYml.getString("build-number"));
        this.buildDate = StringUtils.stripToNull((String)pluginYml.getString("build-date"));
        int fileCount = ReflectionManager.getJarFileCount(this.getFile(), CompileMethods.ignoredDirectories());
        if (fileCount != (expected = pluginYml.getInt("file-count", fileCount))) {
            this.getLogger().severe("Lib's Disguises may be infected with malware, there were " + (fileCount - expected) + " unknown files injected into the jar. Please redownload from a trusted source such as SpigotMC. If this warning shows even after updating, try https://www.spigotmc.org/resources/spigot-anti-malware.64982/ but you will likely need to reinstall all your plugins, jars, etc as just one infected plugin will infect everything else when it loads.");
            this.getLogger().severe("This normally happens when a server owner is tricked into adding third party plugins. Please note that Lib's Disguises is only detecting this and doesn't know what plugins are infected, only that Lib's Disguises itself has been infected");
        }
    }

    private void logInfo() {
        this.getLogger().info("File Name: " + this.getFile().getName());
        String nmsPackageName = ReflectionManager.getNmsPackage();
        if (nmsPackageName.isEmpty()) {
            nmsPackageName = "{Not package relocated}";
        }
        this.getLogger().info("Discovered nms version: (Package: " + nmsPackageName + ") (LD: " + (Object)((Object)ReflectionManager.getVersion()) + ") (MC: " + ReflectionManager.getMinecraftVersion() + ")");
        this.getLogger().info("Jenkins Build: " + (this.isNumberedBuild() ? "#" : "") + this.getBuildNo());
        this.getLogger().info("Build Date: " + this.buildDate);
    }

    private void someMoreLogging() {
        if (!LibsPremium.isPremium().booleanValue()) {
            this.getLogger().info("You are running the free version, commands limited to non-players and operators. (Console, Command Blocks, Admins)");
        }
        if (!DisguiseConfig.isTallSelfDisguises()) {
            DisguiseUtilities.getLogger().info("Config 'TallSelfDisguises' is set to 'false', LD will hide oversized disguises from self disguise. https://www.spigotmc.org/wiki/lib-s-disguises-faq/#tall-disguises-self-disguises");
        }
    }

    private void startOutdatedPacketevents() {
        if (!DisguiseConfig.isNeverUpdatePacketEvents() && DisguiseUtilities.isPacketEventsOutdated()) {
            String requiredPacketEvents = PacketEventsUpdater.getMinimumPacketEventsVersion();
            String version = Bukkit.getPluginManager().getPlugin("packetevents").getDescription().getVersion();
            BukkitRunnable runnable = this.createPacketEventsOutdatedRunnable(version, requiredPacketEvents);
            runnable.run();
            runnable.runTaskTimer((Plugin)this, 20L, 12000L);
        }
        PacketEventsUpdater.doShadedWarning();
    }

    private void registerCommands() {
        this.registerCommand("libsdisguises", new LibsDisguisesCommand());
        this.registerCommand("disguise", new DisguiseCommand());
        this.registerCommand("undisguise", new UndisguiseCommand());
        this.registerCommand("disguiseplayer", new DisguisePlayerCommand());
        this.registerCommand("undisguiseplayer", new UndisguisePlayerCommand());
        this.registerCommand("undisguiseentity", new UndisguiseEntityCommand());
        this.registerCommand("disguiseentity", new DisguiseEntityCommand());
        this.registerCommand("disguiseradius", new DisguiseRadiusCommand());
        this.registerCommand("undisguiseradius", new UndisguiseRadiusCommand());
        this.registerCommand("disguisehelp", new DisguiseHelpCommand());
        this.registerCommand("disguiseclone", new DisguiseCloneCommand());
        this.registerCommand("disguiseviewself", new DisguiseViewSelfCommand());
        this.registerCommand("disguiseviewbar", new DisguiseViewBarCommand());
        this.registerCommand("disguisemodify", new DisguiseModifyCommand());
        this.registerCommand("disguisemodifyentity", new DisguiseModifyEntityCommand());
        this.registerCommand("disguisemodifyplayer", new DisguiseModifyPlayerCommand());
        this.registerCommand("disguisemodifyradius", new DisguiseModifyRadiusCommand());
        this.registerCommand("copydisguise", new CopyDisguiseCommand());
        this.registerCommand("grabskin", new GrabSkinCommand());
        this.registerCommand("savedisguise", new SaveDisguiseCommand());
        this.registerCommand("grabhead", new GrabHeadCommand());
        this.unregisterCommands(false);
    }

    @NotNull
    private BukkitRunnable createPacketEventsOutdatedRunnable(final String version, final String requiredPacketEvents) {
        return new BukkitRunnable(){
            private int timesRun;

            public void run() {
                LibsDisguises.this.getLogger().severe("!! May I have your attention please !!");
                if (LibsDisguises.this.isPacketEventsUpdateDownloaded()) {
                    LibsDisguises.this.getLogger().severe("An update for PacketEvents has been downloaded and will be installed when the server restarts. When possible, please restart the server. Lib's Disguises may not work correctly until you do so.");
                } else {
                    LibsDisguises.this.getLogger().severe("Update your PacketEvents! You are running " + version + " but the minimum version you should be on is " + requiredPacketEvents + "!");
                    LibsDisguises.this.getLogger().severe("https://www.spigotmc.org/resources/packetevents-api.80279/");
                    LibsDisguises.this.getLogger().severe("Or! Use /ld packetevents - To have Lib's Disguises download the latest release from Modrinth");
                }
                if (this.timesRun++ > 0) {
                    LibsDisguises.this.getLogger().severe("This message is on repeat due to the sheer number of people who don't see this.");
                }
                LibsDisguises.this.getLogger().severe("!! May I have your attention please !!");
            }
        };
    }

    public void unregisterCommands(boolean force) {
        SimpleCommandMap map = ReflectionManager.getCommandMap();
        Map<String, Command> commands = ReflectionManager.getCommands((CommandMap)map);
        for (String command : this.getDescription().getCommands().keySet()) {
            PluginCommand cmd = this.getCommand("libsdisguises:" + command);
            if (cmd == null || cmd.getExecutor() != this && !force) continue;
            if (cmd.getPermission() != null && cmd.getPermission().startsWith("libsdisguises.seecmd")) {
                Bukkit.getPluginManager().removePermission(cmd.getPermission());
            }
            Iterator<Map.Entry<String, Command>> itel = commands.entrySet().iterator();
            while (itel.hasNext()) {
                Map.Entry<String, Command> entry = itel.next();
                if (entry.getValue() != cmd) continue;
                itel.remove();
            }
        }
    }

    @NotNull
    public File getFile() {
        return super.getFile();
    }

    public void onDisable() {
        DisguiseUtilities.saveDisguises();
        ClassMappings.saveMappingsCache(this.getDataFolder());
        this.reloaded = true;
    }

    public boolean isReleaseBuild() {
        return !this.getDescription().getVersion().contains("-SNAPSHOT");
    }

    public String getBuildNo() {
        return this.buildNumber;
    }

    public int getBuildNumber() {
        return this.isNumberedBuild() ? Integer.parseInt(this.getBuildNo()) : 0;
    }

    public boolean isNumberedBuild() {
        return this.getBuildNo() != null && this.getBuildNo().matches("\\d+");
    }

    private void registerCommand(String commandName, CommandExecutor executioner) {
        String name = this.commandConfig.getCommand(commandName);
        if (name == null) {
            return;
        }
        PluginCommand command = this.getCommand("libsdisguises:" + name);
        if (command == null) {
            return;
        }
        command.setExecutor(executioner);
        if (executioner instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)executioner);
        }
    }

    @Deprecated
    public void reload() {
        DisguiseConfig.loadConfig();
    }

    public DisguiseListener getListener() {
        return this.listener;
    }

    public static LibsDisguises getInstance() {
        return instance;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public boolean isReloaded() {
        return this.reloaded;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PlayerSkinHandler getSkinHandler() {
        return this.skinHandler;
    }

    public void setPacketEventsUpdateDownloaded(boolean packetEventsUpdateDownloaded) {
        this.packetEventsUpdateDownloaded = packetEventsUpdateDownloaded;
    }

    public boolean isPacketEventsUpdateDownloaded() {
        return this.packetEventsUpdateDownloaded;
    }
}

